/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.servlets.impl;

import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.servlets.MobileService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class MobileServiceImpl
implements MobileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileServiceImpl.class);
    @ComponentImport
    private final TemplateRenderer templateRenderer;
    private final ConfigurationService configurationService;
    private static final String MOBILE_ERROR_TEMPLATE = "/templates/user/mobile/errors.vm";

    @Inject
    public MobileServiceImpl(TemplateRenderer templateRenderer, ConfigurationService configurationService) {
        this.templateRenderer = templateRenderer;
        this.configurationService = configurationService;
    }

    @Override
    public String doGetLockedError() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("locked", true);
        context.put("lockedTime", this.configurationService.getLockoutPeriod());
        return this.getTemplateAsString(context);
    }

    @Override
    public String doGetWrongCodeError(String text) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("wrongCode", true);
        context.put("wrongCodeText", text);
        return this.getTemplateAsString(context);
    }

    @Override
    public String doGetWrongCodeError() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("wrongCode", true);
        return this.getTemplateAsString(context);
    }

    @Override
    public String doGetForcedError() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("forced", true);
        return this.getTemplateAsString(context);
    }

    private String getTemplateAsString(Map<String, Object> context) {
        StringWriter writer = new StringWriter();
        try {
            this.templateRenderer.render(MOBILE_ERROR_TEMPLATE, context, (Writer)writer);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        return ((Object)writer).toString();
    }
}

