/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.rest.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.TwoFAUsersRequestDTO;
import com.alphaserve.twofactor.core.services.TwoFAUserService;
import com.alphaserve.twofactor.core.services.rest.TwoFAUsersRestService;
import com.alphaserve.twofactor.core.validation.AdminPermittedValidation;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.google.gson.Gson;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;

@Named
public class TwoFAUsersRestServiceImpl
implements TwoFAUsersRestService {
    private final TwoFAUserService userService;
    private final AdminPermittedValidation adminPermittedValidation;

    @Inject
    public TwoFAUsersRestServiceImpl(TwoFAUserService userService, AdminPermittedValidation adminPermittedValidation) {
        this.userService = userService;
        this.adminPermittedValidation = adminPermittedValidation;
    }

    @Override
    public Response getUsers(HttpServletRequest request, HttpServletResponse response, TwoFAUsersRequestDTO requestDTO) {
        ValidationResult validationResult = this.adminPermittedValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity(validationResult.getErrors()).build();
        }
        return Response.ok((Object)new Gson().toJson(this.userService.getRequested2FAUsers(requestDTO))).build();
    }
}

