/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.PersonDTO;
import com.alphaserve.twofactor.core.model.entities.cache.wraper.Auth2FACacheWrapper;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.PermissionService;
import com.alphaserve.twofactor.core.services.UserActionService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class PermissionServiceImpl
implements PermissionService {
    private final ConfigurationService configurationService;
    @ComponentImport
    private final UserManager userManager;
    private final Auth2FAService auth2FAService;
    private final UserActionService userActionService;

    @Inject
    public PermissionServiceImpl(ConfigurationService configurationService, @Qualifier(value="userManager") UserManager userManager, Auth2FAService auth2FAService, UserActionService userActionService) {
        this.configurationService = configurationService;
        this.userManager = userManager;
        this.auth2FAService = auth2FAService;
        this.userActionService = userActionService;
    }

    @Override
    public boolean isTrusted(UserProfile userProfile) {
        if (Objects.isNull(userProfile)) {
            return false;
        }
        Auth2FACacheWrapper auth2FA = this.auth2FAService.getWrappedEntityByUserKey(userProfile.getUserKey());
        if (auth2FA.isActive() && auth2FA.isConfirmed()) {
            switch (this.configurationService.getAuthPermissionType()) {
                case "permissionGroups": {
                    return this.isUserInGroups(userProfile, this.configurationService.getAuthForceGroupsList());
                }
                case "permissionUsers": {
                    return this.isUserInList(userProfile, this.configurationService.getAuthPermissionUsersList());
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public List<PersonDTO> preparePersons(String[] usernames) {
        return this.userActionService.findSelectedUsers(usernames);
    }

    private boolean isUserInGroups(UserProfile userProfile, String[] groupsList) {
        for (String group : groupsList) {
            if (!this.userManager.isUserInGroup(userProfile.getUserKey(), group)) continue;
            switch (this.configurationService.getAuthLimitationType()) {
                case "permissionLimitationNone": {
                    return true;
                }
                case "permissionLimitationUsers": {
                    return Arrays.stream(this.configurationService.getAuthLimitationUsersList()).noneMatch(user -> user.equals(userProfile.getUsername()));
                }
                case "permissionLimitationGroups": {
                    return Arrays.stream(this.configurationService.getAuthLimitationGroupsList()).noneMatch(limitedGroup -> this.userManager.isUserInGroup(userProfile.getUserKey(), limitedGroup));
                }
            }
        }
        return false;
    }

    private boolean isUserInList(UserProfile userProfile, String[] usersList) {
        for (String username : usersList) {
            if (!userProfile.getUsername().equals(username)) continue;
            return true;
        }
        return false;
    }
}

