/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.export.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionDTO;
import com.alphaserve.twofactor.core.services.export.ExcelExportService;
import com.alphaserve.twofactor.core.services.export.OwnTimeZoneManager;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class XlsExportService
extends ExcelExportService {
    public static int MAX_ROWS = 65535;
    protected final Logger logger = LoggerFactory.getLogger(ExcelExportService.class);

    @Inject
    public XlsExportService(I18nResolver i18nResolver, OwnTimeZoneManager timeZoneManager) {
        super(i18nResolver, timeZoneManager);
    }

    @Override
    public ByteArrayOutputStream getLogs(List<LogActionDTO> logs) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        return this.generate(workbook, workbook.createSheet(this.i18nResolver.getText("auth.export.logger.sheet")), logs);
    }

    public ByteArrayOutputStream generateZip(List<LogActionDTO> logs) {
        int countFiles = (int)Math.ceil((double)logs.size() / ((double)MAX_ROWS * 1.0));
        String zipFile = "archive.zip";
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int length;
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (int i = 0; i < countFiles; ++i) {
                zos.putNextEntry(new ZipEntry(i + 1 + ".xls"));
                ByteArrayOutputStream arrayOutputStream = this.getLogs(logs.subList(i * MAX_ROWS, i == countFiles - 1 ? logs.size() : (i + 1) * MAX_ROWS));
                zos.write(arrayOutputStream.toByteArray());
                zos.closeEntry();
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            zos.close();
            fos.close();
            FileInputStream fis = new FileInputStream(zipFile);
            while ((length = fis.read(buffer)) > 0) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
            fis.close();
            new File(zipFile).delete();
        }
        catch (IOException ioe) {
            this.logger.error(ioe.getMessage(), ioe);
        }
        return byteArrayOutputStream;
    }
}

