/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.model.entities.U2FDevice;
import com.alphaserve.twofactor.core.services.database.TwoFADatabaseToolkit;
import com.alphaserve.twofactor.core.services.entities.U2FDeviceService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class U2FDeviceServiceImpl
implements U2FDeviceService {
    @ComponentImport
    protected final UserManager salUserManager;
    protected final TwoFADatabaseToolkit dbToolkit;

    protected U2FDeviceServiceImpl(@Qualifier(value="userManager") UserManager salUserManager, TwoFADatabaseToolkit dbToolkit) {
        this.salUserManager = salUserManager;
        this.dbToolkit = dbToolkit;
    }

    @Override
    public U2FDevice add(String userKey, String name, Date createdAt, String registerJson) {
        return this.dbToolkit.useActiveObjects(ao -> (U2FDevice)ao.executeInTransaction(() -> {
            U2FDevice u2FD = (U2FDevice)ao.create(U2FDevice.class, new DBParam[0]);
            u2FD.setCreatedAt(createdAt);
            u2FD.setName(name);
            u2FD.setUserKey(userKey);
            u2FD.setRegisterDataJson(registerJson);
            u2FD.save();
            return u2FD;
        }), this.dbToolkit::returnNull);
    }

    @Override
    public U2FDevice getById(int id) {
        return this.dbToolkit.useActiveObjects(ao -> (U2FDevice)ao.executeInTransaction(() -> (U2FDevice)ao.get(U2FDevice.class, (Object)id)), this.dbToolkit::returnNull);
    }

    @Override
    public List<U2FDevice> getByUserKey(UserKey userKey) {
        Query query = Query.select().where("USERKEY = ?", new Object[]{userKey.getStringValue()});
        U2FDevice[] userAuthSetting = this.dbToolkit.useActiveObjects(ao -> (U2FDevice[])ao.executeInTransaction(() -> (U2FDevice[])ao.find(U2FDevice.class, query)), this.dbToolkit::returnNull);
        if (Objects.isNull(userAuthSetting)) {
            return new ArrayList<U2FDevice>();
        }
        return Lists.newArrayList(userAuthSetting);
    }

    @Override
    public void delete(U2FDevice auth2FA) {
        this.dbToolkit.useActiveObjects(ao -> ao.delete(new RawEntity[]{auth2FA}));
    }

    @Override
    public boolean hasRemoteUserU2FDevice() {
        UserProfile remoteUser = this.salUserManager.getRemoteUser();
        if (Objects.isNull(remoteUser)) {
            return false;
        }
        return this.dbToolkit.useActiveObjects(ao -> (Integer)ao.executeInTransaction(() -> {
            Query query = Query.select().where("USERKEY = ?", new Object[]{remoteUser.getUserKey().getStringValue()});
            return ao.count(U2FDevice.class, query);
        }) > 0, this.dbToolkit::returnFalse);
    }

    @Override
    public long getDeviceCountByName(String name) {
        UserProfile remoteUser = this.salUserManager.getRemoteUser();
        if (Objects.isNull(remoteUser)) {
            return 0L;
        }
        return this.dbToolkit.useActiveObjects(ao -> (Integer)ao.executeInTransaction(() -> {
            Query query = Query.select().where("NAME = ? AND USERKEY = ?", new Object[]{name, remoteUser.getUserKey().getStringValue()});
            return ao.count(U2FDevice.class, query);
        }), () -> 0).intValue();
    }

    @Override
    public void deleteAll() {
        this.dbToolkit.useActiveObjects(ao -> ao.deleteWithSQL(U2FDevice.class, "ID > ?", new Object[]{0}));
    }

    @Override
    public void deleteByUserKey(String userKey) {
        this.dbToolkit.useActiveObjects(ao -> ao.deleteWithSQL(U2FDevice.class, "USERKEY = ?", new Object[]{userKey}));
    }
}

