/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.IpRepresentation;
import com.alphaserve.twofactor.core.model.entities.FailLogin2FA;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.database.TwoFADatabaseToolkit;
import com.alphaserve.twofactor.core.services.entities.FailLogin2FAService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.utils.StringUsefulUtils;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang3.time.DateUtils;

@Named
public class FailLogin2FAServiceImpl
implements FailLogin2FAService {
    private final TwoFADatabaseToolkit dbToolkit;
    private final ConfigurationService configurationService;
    private final IpFilterService ipFilterService;

    @Inject
    public FailLogin2FAServiceImpl(TwoFADatabaseToolkit dbToolkit, ConfigurationService configurationService, IpFilterService ipFilterService) {
        this.dbToolkit = dbToolkit;
        this.configurationService = configurationService;
        this.ipFilterService = ipFilterService;
    }

    @Override
    public FailLogin2FA add(String userKey, String ipAddress) {
        if (this.configurationService.getAuthBruteForceEnable()) {
            return this.dbToolkit.useActiveObjects(ao -> (FailLogin2FA)ao.executeInTransaction(() -> {
                FailLogin2FA failLogin2FA = (FailLogin2FA)ao.create(FailLogin2FA.class, new DBParam[0]);
                failLogin2FA.setIpAddress(ipAddress);
                failLogin2FA.setUserKey(userKey);
                failLogin2FA.setCreatedAt(new Date(System.currentTimeMillis()));
                failLogin2FA.save();
                return failLogin2FA;
            }), this.dbToolkit::returnNull);
        }
        return null;
    }

    @Override
    public boolean isLocked(String userKey, HttpServletRequest request) {
        if (this.configurationService.getAuthBruteForceEnable()) {
            String ipAddress = this.convertIpToString(this.ipFilterService.getClientIpAddress(request));
            int attempts = this.configurationService.getNumberAttempts();
            int period = this.configurationService.getLockoutPeriod();
            Date date = DateUtils.addMinutes(new Date(System.currentTimeMillis()), -period);
            Query query = Query.select().where("USERKEY = ? AND IP_ADDRESS = ? AND CREATEDAT >= ?", new Object[]{userKey, ipAddress, date});
            return this.dbToolkit.useActiveObjects(ao -> (Integer)ao.executeInTransaction(() -> ao.count(FailLogin2FA.class, query)) >= attempts, this.dbToolkit::returnFalse);
        }
        return false;
    }

    @Override
    public String convertIpToString(List<IpRepresentation> ipRepresentations) {
        List<String> collectedIp = ipRepresentations.stream().map(ipRepresentation -> ipRepresentation.getHeader() + ":" + ipRepresentation.getIp()).collect(Collectors.toList());
        return StringUsefulUtils.getComaSplitStringFromList(collectedIp);
    }
}

