/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.database;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsModuleMetaData;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class TwoFADatabaseToolkit {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwoFADatabaseToolkit.class);
    @ComponentImport
    private final ActiveObjects ao;
    private boolean activeObjectsReady = false;

    @Inject
    public TwoFADatabaseToolkit(ActiveObjects ao) {
        this.ao = Preconditions.checkNotNull(ao);
    }

    private boolean isActiveObjectsReady() {
        if (!this.activeObjectsReady) {
            if (!this.ao.moduleMetaData().isInitialized()) {
                try {
                    this.ao.moduleMetaData().awaitInitialization(15L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException exception) {
                    log.error("Issues with ActiveObjects", exception);
                    return false;
                }
                catch (InterruptedException exception) {
                    log.error("Issues with ActiveObjects", exception);
                    Thread.currentThread().interrupt();
                }
            }
            this.activeObjectsReady = this.ao.moduleMetaData().isInitialized();
        }
        return this.activeObjectsReady;
    }

    public <T> T returnNull() {
        return null;
    }

    public boolean returnFalse() {
        return false;
    }

    public <T> T useActiveObjects(Function<ActiveObjects, T> aoFunction, Supplier<T> onError) {
        return this.isActiveObjectsReady() ? aoFunction.apply(this.ao) : onError.get();
    }

    public void useActiveObjects(Consumer<ActiveObjects> aoFunction) {
        if (this.isActiveObjectsReady()) {
            aoFunction.accept(this.ao);
        }
    }

    public ActiveObjectsModuleMetaData openAOModuleMetaData() {
        return this.ao.moduleMetaData();
    }

    public static class U2FDeviceServiceImpl {
        public static final String FIND_BY_USER_KEY = "USERKEY = ?";
    }

    public static final class CredentialQuery {
        public static final String FIND_BY_USER_KEY = "USER_KEY = ?";

        @Generated
        private CredentialQuery() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

