/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.security;

import com.alphaserve.twofactor.core.model.QRCodeGenerator;
import com.alphaserve.twofactor.core.utils.StringUsefulUtils;
import com.google.common.io.BaseEncoding;
import com.google.zxing.WriterException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Totp {
    private long timeStep;
    private String label;
    private int keySize;
    private final int DUO_MILLIS = 30000;

    public static Totp build(long timeStep, String label, int keySize) {
        return new Totp(timeStep, label, keySize);
    }

    private Totp(long timeStep, String label, int keySize) {
        this.timeStep = timeStep;
        this.label = label;
        this.keySize = keySize;
    }

    public void setTimeStep(long timeStep) {
        this.timeStep = timeStep;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String generateBase32Secret() {
        return this.generateBase32Secret(this.keySize);
    }

    public String generateBase32Secret(int length) {
        StringBuilder sb = new StringBuilder(length);
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            int val = random.nextInt(32);
            if (val < 26) {
                sb.append((char)(65 + val));
                continue;
            }
            sb.append((char)(50 + (val - 26)));
        }
        return sb.toString();
    }

    public boolean validateCurrentNumber(String base32Secret, int authNumber, int windowMillis, boolean isDuo) throws GeneralSecurityException {
        boolean isValid = this.validateCurrentNumber(base32Secret, authNumber, windowMillis, System.currentTimeMillis(), this.timeStep);
        if (isDuo && !isValid) {
            isValid = this.validateCurrentNumber(base32Secret, authNumber, windowMillis, System.currentTimeMillis() - 30000L, this.timeStep);
        }
        return isValid;
    }

    private boolean validateCurrentNumber(String base32Secret, int authNumber, int windowMillis, long timeMillis, long timeStepSeconds) throws GeneralSecurityException {
        long from = timeMillis;
        long to = timeMillis;
        if (windowMillis > 0) {
            from -= (long)windowMillis;
            to += (long)windowMillis;
        }
        long timeStepMillis = timeStepSeconds * 1000L;
        for (long millis = from; millis <= to; millis += timeStepMillis) {
            long compare = this.generateNumber(base32Secret, millis, timeStepSeconds);
            if (compare != (long)authNumber) continue;
            return true;
        }
        return false;
    }

    private long generateNumber(String base32Secret, long timeMillis, long timeStepSeconds) throws GeneralSecurityException {
        byte[] key = BaseEncoding.base32().decode(base32Secret);
        byte[] data = new byte[8];
        long value = timeStepSeconds != 0L ? timeMillis / 1000L / timeStepSeconds : timeMillis / 1000L / 30L;
        int i = 7;
        while (value > 0L) {
            data[i] = (byte)(value & 0xFFL);
            value >>= 8;
            --i;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[hash.length - 1] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = offset; i2 < offset + 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return truncatedHash %= 1000000L;
    }

    public String qrImageUrl(String secret, String email) throws IOException, WriterException {
        String text = this.getOtpAuthPart(secret, email);
        return Base64.getEncoder().encodeToString(QRCodeGenerator.getQRCodeImage(text, 250, 250));
    }

    private String getOtpAuthPart(String secret, String email) {
        String label = this.label;
        label = StringUsefulUtils.encodeUrl(label);
        return "otpauth://totp/" + label + ":" + email + "?secret=" + secret + "&issuer=" + label + "&period=" + this.timeStep;
    }
}

