/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.model;

import com.alphaserve.twofactor.core.dtolayer.dtos.IpRepresentation;
import com.alphaserve.twofactor.core.model.IpHeaderModels;
import com.alphaserve.twofactor.core.model.exceptions.ParseIPException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class IpValidator {
    private final int nMaskBits;
    private final InetAddress requiredAddress;
    private InetAddress range;

    public IpValidator(String ipAddress) throws ParseIPException {
        int nMaskBits1;
        String[] addressAndMask;
        if (ipAddress.contains("-")) {
            addressAndMask = org.springframework.util.StringUtils.split((String)ipAddress, (String)"-");
            ipAddress = addressAndMask[0];
            this.range = IpValidator.parseAddress(addressAndMask[1]);
        }
        if (ipAddress.indexOf(47) > 0) {
            addressAndMask = org.springframework.util.StringUtils.split((String)ipAddress, (String)"/");
            ipAddress = addressAndMask[0];
            try {
                nMaskBits1 = Integer.parseInt(addressAndMask[1]);
            }
            catch (NumberFormatException e) {
                try {
                    nMaskBits1 = IpValidator.convertNetmaskToCIDR(IpValidator.parseAddress(addressAndMask[1]));
                }
                catch (IllegalArgumentException e2) {
                    nMaskBits1 = -1;
                }
            }
        } else {
            nMaskBits1 = -1;
        }
        this.nMaskBits = nMaskBits1;
        this.requiredAddress = IpValidator.parseAddress(ipAddress);
    }

    public boolean matches(IpRepresentation address, boolean isLocal) throws ParseIPException {
        int i;
        InetAddress remoteAddress = IpValidator.parseAddress(address.getIp());
        if (isLocal && !Arrays.asList(IpHeaderModels.IP_HEADER_LOCAL_CANDIDATES).contains(address.getHeader())) {
            return false;
        }
        if (!this.requiredAddress.getClass().equals(remoteAddress.getClass())) {
            return false;
        }
        if (Objects.nonNull(this.range)) {
            return IpValidator.isValidRange(this.requiredAddress.getHostName(), this.range.getHostAddress(), address.getIp());
        }
        if (this.nMaskBits < 0) {
            return remoteAddress.equals(this.requiredAddress);
        }
        byte[] remAddr = remoteAddress.getAddress();
        byte[] reqAddr = this.requiredAddress.getAddress();
        int oddBits = this.nMaskBits % 8;
        int nMaskBytes = this.nMaskBits / 8 + (oddBits == 0 ? 0 : 1);
        byte[] mask = new byte[nMaskBytes];
        Arrays.fill(mask, 0, oddBits == 0 ? mask.length : mask.length - 1, (byte)-1);
        if (oddBits != 0) {
            i = (1 << oddBits) - 1;
            mask[mask.length - 1] = (byte)(i <<= 8 - oddBits);
        }
        for (i = 0; i < mask.length; ++i) {
            if ((remAddr[i] & mask[i]) == (reqAddr[i] & mask[i])) continue;
            return false;
        }
        return true;
    }

    public boolean matches(List<IpRepresentation> address, boolean isLocal) throws ParseIPException {
        for (IpRepresentation ipEntry : address) {
            if (!this.matches(ipEntry, isLocal)) continue;
            return true;
        }
        return false;
    }

    private static InetAddress parseAddress(String address) throws ParseIPException {
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException var3) {
            throw new ParseIPException("Failed to parse address" + address, var3);
        }
    }

    public static boolean isValidRange(String ipStart, String ipEnd, String ipToCheck) {
        try {
            long ipLo = IpValidator.ipToLong(InetAddress.getByName(ipStart));
            long ipHi = IpValidator.ipToLong(InetAddress.getByName(ipEnd));
            long ipToTest = IpValidator.ipToLong(InetAddress.getByName(ipToCheck));
            return ipToTest >= ipLo && ipToTest <= ipHi;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0L;
        for (byte octet : octets) {
            result <<= 8;
            result |= (long)(octet & 0xFF);
        }
        return result;
    }

    public static boolean validateAddress(String address) throws ParseIPException {
        if (StringUtils.isBlank(address)) {
            return false;
        }
        try {
            String[] addressAndMask = org.springframework.util.StringUtils.split((String)address, (String)"/");
            if (address.indexOf(47) > 0) {
                String ipAddress = addressAndMask[0];
                try {
                    Integer.parseInt(addressAndMask[1]);
                }
                catch (NumberFormatException e) {
                    throw new UnknownHostException();
                }
                InetAddress.getByName(ipAddress);
                return true;
            }
            InetAddress.getByName(address);
            return true;
        }
        catch (UnknownHostException var3) {
            if (address.contains("/")) {
                String[] addr = address.split("/", 2);
                String ipAddress = addr[0];
                String maskAddress = addr[1];
                InetAddress ipAddr = IpValidator.parseAddress(maskAddress);
                IpValidator.convertNetmaskToCIDR(ipAddr);
                try {
                    InetAddress.getByName(ipAddress);
                    return true;
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
            if (address.contains("-")) {
                String[] addr = address.split("-", 2);
                String ipAddress = addr[0];
                String ipAddress2 = addr[1];
                try {
                    InetAddress.getByName(ipAddress2);
                    InetAddress.getByName(ipAddress);
                    return true;
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
            return false;
        }
    }

    private static int convertNetmaskToCIDR(InetAddress netmask) throws ParseIPException {
        byte[] netmaskBytes = netmask.getAddress();
        int cidr = 0;
        boolean zero = false;
        for (byte b : netmaskBytes) {
            int mask = 128;
            for (int i = 0; i < 8; ++i) {
                int result = b & mask;
                if (result == 0) {
                    zero = true;
                } else {
                    if (zero) {
                        throw new ParseIPException("Invalid netmask.");
                    }
                    ++cidr;
                }
                mask >>>= 1;
            }
        }
        return cidr;
    }
}

