/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.dtolayer.converter;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionDTO;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.model.entities.LogAction;
import com.alphaserve.twofactor.core.services.export.OwnTimeZoneManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.text.SimpleDateFormat;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;

@Named
@Component
public class LogActionDTOConverter
implements DoForwardConverter<LogAction, LogActionDTO> {
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private OwnTimeZoneManager timeZoneManager;
    @ComponentImport
    private I18nResolver i18nResolver;

    @Inject
    public LogActionDTOConverter(OwnTimeZoneManager timeZoneManager, I18nResolver i18nResolver) {
        this.timeZoneManager = timeZoneManager;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public LogActionDTO doForward(LogAction entity) {
        this.simpleDateFormat.setTimeZone(this.timeZoneManager.getUserTimeZone());
        LogActionType actionType = this.getLogActionType(entity.getActionType());
        if (Objects.isNull((Object)actionType)) {
            return null;
        }
        return LogActionDTO.builder().action(this.getActionTypeI18n(actionType, entity)).date(this.simpleDateFormat.format(entity.getDate())).userIp(HtmlUtils.htmlEscape((String)entity.getUserIP())).username(HtmlUtils.htmlEscape((String)entity.getUsername())).adminUsername(Objects.nonNull(entity.getAdminUsername()) ? HtmlUtils.htmlEscape((String)entity.getAdminUsername()) : null).build();
    }

    private LogActionType getLogActionType(String actionType) {
        LogActionType logActionType;
        try {
            logActionType = LogActionType.valueOf(actionType.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
        return logActionType;
    }

    private String getActionTypeI18n(LogActionType action, LogAction entity) {
        switch (action) {
            case ADD: {
                return this.i18nResolver.getText("auth.text.log-add");
            }
            case PASS_2FA_SUCCESS: {
                return this.i18nResolver.getText("auth.text.log-enter-success");
            }
            case PASS_2FA_FAILED: {
                return this.i18nResolver.getText("auth.text.log-enter-failed");
            }
            case REVOKE: {
                return this.i18nResolver.getText("auth.text.log-revoke");
            }
            case U2FADD: {
                return this.i18nResolver.getText("auth.text.log-u2f-add");
            }
            case U2FDELETE: {
                return this.i18nResolver.getText("auth.text.log-u2f-delete");
            }
            case PASS_2FA_REMEMBER: {
                return this.i18nResolver.getText("auth.text.log-enter-remember");
            }
            case RESET_BY_ADMIN: {
                return this.i18nResolver.getText("auth.text.log-reset-by-admin") + ": " + entity.getAdminUsername();
            }
        }
        return this.i18nResolver.getText("auth.text.log-unknown");
    }
}

