/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.dao;

import com.alphaserve.twofactor.core.dao.TwoFAUsersDao;
import com.alphaserve.twofactor.core.dtolayer.dtos.PersonDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.TwoFAPage;
import com.alphaserve.twofactor.core.dtolayer.dtos.TwoFAPageRequest;
import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.services.UserActionService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultTwoFAUsersDaoImpl
implements TwoFAUsersDao {
    private final Auth2FAService auth2FAService;
    private final UserActionService userActionService;

    @Inject
    public DefaultTwoFAUsersDaoImpl(Auth2FAService auth2FAService, UserActionService userActionService) {
        this.auth2FAService = auth2FAService;
        this.userActionService = userActionService;
    }

    private Predicate<PersonDTO> acceptAllTwoFAUsers() {
        return ignore -> true;
    }

    private TwoFAPage<PersonDTO> complexSearch(TwoFAPageRequest pageRequest, Predicate<PersonDTO> canBeAdded, Function<TwoFAPageRequest, TwoFAPage<PersonDTO>> userActionServiceStrategy) {
        int personsResultLimit = pageRequest.getLimit();
        ArrayList<PersonDTO> result = new ArrayList<PersonDTO>(personsResultLimit);
        Object nextPageData = pageRequest.getPlatformBasedPageInfo();
        do {
            TwoFAPageRequest newPageRequest = TwoFAPageRequest.of(nextPageData, personsResultLimit);
            TwoFAPage<PersonDTO> personsPage = userActionServiceStrategy.apply(newPageRequest);
            Object[] keys = personsPage.stream().map(PersonDTO::getKey).toArray();
            List authUserKeys = Arrays.stream(this.auth2FAService.getByUserKeys(keys)).map(Auth2FA::getUserKey).collect(Collectors.toList());
            nextPageData = personsPage.getPlatformBasedPageInfo();
            for (PersonDTO person : personsPage.getResult()) {
                PersonDTO twoFAUser;
                PersonDTO personDTO = twoFAUser = authUserKeys.stream().noneMatch(person.getKey()::equals) ? PersonDTO.createInactiveUser(person) : PersonDTO.createActiveUser(person);
                if (!canBeAdded.test(twoFAUser)) continue;
                result.add(twoFAUser);
            }
        } while (result.size() < personsResultLimit && Objects.nonNull(nextPageData));
        return new TwoFAPage<PersonDTO>(nextPageData, result.toArray(new PersonDTO[0]));
    }

    @Override
    public TwoFAPage<PersonDTO> findActiveUsers(TwoFAPageRequest pageRequest) {
        return this.complexSearch(pageRequest, PersonDTO::isActiveIn2FA, this.userActionService::requestedActiveUser);
    }

    @Override
    public TwoFAPage<PersonDTO> findInactiveUsers(TwoFAPageRequest pageRequest) {
        return this.complexSearch(pageRequest, PersonDTO::isInactiveIn2FA, this.userActionService::requestedActiveUser);
    }

    @Override
    public TwoFAPage<PersonDTO> findUsers(TwoFAPageRequest pageRequest) {
        return this.complexSearch(pageRequest, this.acceptAllTwoFAUsers(), this.userActionService::requestedActiveUser);
    }

    @Override
    public TwoFAPage<PersonDTO> findByEmail(String email, TwoFAPageRequest pageRequest) {
        return this.complexSearch(pageRequest, this.acceptAllTwoFAUsers(), argPageRequest -> this.userActionService.findUsersByEmail(email, (TwoFAPageRequest)argPageRequest));
    }

    @Override
    public TwoFAPage<PersonDTO> findByName(String name, TwoFAPageRequest pageRequest) {
        return this.complexSearch(pageRequest, this.acceptAllTwoFAUsers(), argPageRequest -> this.userActionService.findUsers(name, (TwoFAPageRequest)argPageRequest));
    }
}

