/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.confluence.authplugin.resources;

import com.alphaserve.twofactor.core.dtolayer.dtos.CredentialName;
import com.alphaserve.twofactor.core.dtolayer.dtos.U2FLoginDTO;
import com.alphaserve.twofactor.core.services.rest.WebAuthnRestService;
import com.atlassian.xwork.RequireSecurityToken;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import lombok.NonNull;

@Named
@Path(value="/webauth_resources")
public class WebAuthResources {
    private final WebAuthnRestService restService;

    @Inject
    public WebAuthResources(WebAuthnRestService restService) {
        this.restService = restService;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/init_registration")
    public final Response initRegistration(@Context HttpServletRequest request, @Context HttpServletResponse response, CredentialName dto) {
        return this.restService.getPublicKey(request, response, dto);
    }

    @POST
    @Consumes(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/finish_registration")
    public final Response finishRegistration(@Context HttpServletRequest request, @Context HttpServletResponse response, @NonNull String responseJson) {
        if (responseJson == null) {
            throw new NullPointerException("responseJson is marked non-null but is null");
        }
        return this.restService.finishRegistration(request, response, responseJson);
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/init_assertion")
    public final Response initAssertion(@Context HttpServletRequest request, @Context HttpServletResponse response) {
        return this.restService.initLogin(request, response);
    }

    @POST
    @Consumes(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/finish_login")
    public final Response finishLogin(@Context HttpServletRequest request, @Context HttpServletResponse response, @NonNull U2FLoginDTO finishLoginDTO) {
        if (finishLoginDTO == null) {
            throw new NullPointerException("finishLoginDTO is marked non-null but is null");
        }
        return this.restService.finishLogin(request, response, finishLoginDTO.getTokenResponse(), finishLoginDTO.isRememberMe());
    }

    @GET
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/user_credentials")
    public final Response geUserCredentials(@Context HttpServletRequest request, @Context HttpServletResponse response) {
        return this.restService.geUserCredentials(request, response);
    }

    @GET
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/delete_credential")
    public final Response deleteUserCredential(@Context HttpServletRequest request, @Context HttpServletResponse response, @QueryParam(value="deviceId") String id) {
        return this.restService.deleteUserCredential(request, response, id);
    }
}

