/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.confluence.authplugin.resources;

import com.alphaserve.twofactor.core.dtolayer.dtos.U2FLoginDTO;
import com.alphaserve.twofactor.core.services.rest.DeviceRestService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.xwork.RequireSecurityToken;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Named
@Path(value="/u2f_resources")
public class U2FResources {
    private DeviceRestService deviceRestService;

    @Inject
    public U2FResources(DeviceRestService deviceRestService) {
        this.deviceRestService = deviceRestService;
    }

    @GET
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/get_remote_user_devices")
    public final Response getCurrentUserU2FDevices(@Context HttpServletRequest request) {
        return this.deviceRestService.getCurrentUserU2FDevices(request);
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/delete_device")
    public final Response deleteUserU2FDevice(@Context HttpServletRequest request, @Context HttpServletResponse response, @QueryParam(value="deviceId") String deviceId) {
        return this.deviceRestService.deleteCurrentUserU2FDevice(request, response, deviceId);
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/init_login")
    public final Response initU2fLogin(@Context HttpServletRequest request) {
        return this.deviceRestService.initU2fLogin(request);
    }

    @POST
    @Produces
    @RequireSecurityToken(value=true)
    @Path(value="/login")
    @ReadOnlyAccessAllowed
    public final Response login(@Context HttpServletRequest request, @Context HttpServletResponse response, U2FLoginDTO u2FLoginDTO) {
        return this.deviceRestService.loginWithU2F(request, response, u2FLoginDTO);
    }

    @POST
    @Produces
    @RequireSecurityToken(value=true)
    @Path(value="/init_register")
    public final Response initU2fDeviceRegister(@Context HttpServletRequest request) {
        return this.deviceRestService.initU2fDeviceRegistration(request);
    }

    @POST
    @Produces
    @RequireSecurityToken(value=true)
    @Path(value="/register")
    public final Response registerU2fDevice(@Context HttpServletRequest request, @Context HttpServletResponse response, U2FLoginDTO u2FLoginDTO) {
        return this.deviceRestService.registerU2fDevice(request, response, u2FLoginDTO);
    }
}

