/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.confluence.authplugin.resources;

import com.alphaserve.twofactor.core.dtolayer.dtos.ConfigDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.GroupDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.UsernameDTO;
import com.alphaserve.twofactor.core.services.rest.ConfigRestService;
import com.alphaserve.twofactor.core.services.rest.UserManagerRestService;
import com.atlassian.xwork.RequireSecurityToken;
import com.fasterxml.jackson.core.JsonProcessingException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Named
@Path(value="/tfaservices")
public class TFAResources {
    private ConfigRestService configRestService;
    private UserManagerRestService userManagerRestService;

    @Inject
    public TFAResources(ConfigRestService configRestService, UserManagerRestService userManagerRestService) {
        this.configRestService = configRestService;
        this.userManagerRestService = userManagerRestService;
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/reset")
    public final Response resetData(@Context HttpServletRequest request, @Context HttpServletResponse response) {
        return this.configRestService.resetToDefault(request, response);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/logout")
    public final Response logout(@Context HttpServletRequest request, @Context HttpServletResponse response) {
        return this.userManagerRestService.logout(request, response);
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/find_users_by_query")
    public final Response findUsersByQuery(@Context HttpServletRequest request, @Context HttpServletResponse response, UsernameDTO usernameDTO) {
        return this.userManagerRestService.findUsers(request, response, usernameDTO);
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/find_groups")
    public final Response findGroups(@Context HttpServletRequest request, @Context HttpServletResponse response, GroupDTO groupDTO) {
        return this.userManagerRestService.findGroups(request, response, groupDTO);
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/save_admin_config")
    public final Response saveAdminConfig(@Context HttpServletRequest request, @Context HttpServletResponse response, String configDTO) throws JsonProcessingException {
        return this.configRestService.saveConfigurations(request, response, ConfigDTO.buildConfigDTO(configDTO));
    }
}

