/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.confluence.authplugin.resources;

import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionFilterDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LoggerDateDTO;
import com.alphaserve.twofactor.core.services.rest.LoggerRestService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.xwork.RequireSecurityToken;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Named
@Path(value="/authlogger")
public class AuthLoggerResource {
    private LoggerRestService loggerRestService;

    @Inject
    public AuthLoggerResource(LoggerRestService loggerRestService) {
        this.loggerRestService = loggerRestService;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/delete")
    public final Response delete(@Context HttpServletRequest request, @Context HttpServletResponse response, LoggerDateDTO loggerDateDTO) {
        return this.loggerRestService.deleteLogs(request, response, loggerDateDTO);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{page}")
    @RequireSecurityToken(value=true)
    @ReadOnlyAccessAllowed
    public final Response get(@Context HttpServletRequest request, @Context HttpServletResponse response, LogActionFilterDTO logActionFilterDTO) {
        return this.loggerRestService.getPage(request, response, logActionFilterDTO);
    }

    @GET
    @Path(value="/export")
    public final Response exportLogs(@Context HttpServletRequest request, @QueryParam(value="startDate") String startDate, @QueryParam(value="finishDate") String finishDate, @QueryParam(value="username") String username, @QueryParam(value="action") String action, @QueryParam(value="userIp") String userIp, @QueryParam(value="type") String type) {
        LogActionFilterDTO logActionFilterDTO = LogActionFilterDTO.shortBuilder().startDate(this.parseDate(startDate)).finishDate(this.parseDate(finishDate)).username(username).action(action).userIp(userIp).build();
        return this.loggerRestService.exportLogs(request, logActionFilterDTO, type);
    }

    private Date parseDate(String date) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(date);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

