/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.confluence.authplugin.converter;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.PersonDTO;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class PersonDTOConverterImpl
implements DoForwardConverter<User, PersonDTO> {
    @ConfluenceImport
    private final UserAccessor userAccessor;

    @Inject
    public PersonDTOConverterImpl(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public PersonDTO doForward(User user) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(user.getName());
        PersonDTO.PersonDTOBuilder builder = PersonDTO.builder();
        if (Objects.nonNull(confluenceUser) && Objects.nonNull(confluenceUser.getKey())) {
            builder.key(confluenceUser.getKey().getStringValue());
        }
        return builder.email(user.getEmail()).username(user.getName()).build();
    }
}

