/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.data.AssertionExtensionInputs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.PublicKeyCredentialHint;
import com.yubico.webauthn.data.UserVerificationRequirement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class PublicKeyCredentialRequestOptions {
    @NonNull
    private final ByteArray challenge;
    private final Long timeout;
    private final List<String> hints;
    private final String rpId;
    private final List<PublicKeyCredentialDescriptor> allowCredentials;
    private final UserVerificationRequirement userVerification;
    @NonNull
    private final AssertionExtensionInputs extensions;

    @JsonCreator
    private PublicKeyCredentialRequestOptions(@JsonProperty(value="challenge") @NonNull ByteArray challenge, @JsonProperty(value="timeout") Long timeout, @JsonProperty(value="hints") List<String> hints, @JsonProperty(value="rpId") String rpId, @JsonProperty(value="allowCredentials") List<PublicKeyCredentialDescriptor> allowCredentials, @JsonProperty(value="userVerification") UserVerificationRequirement userVerification, @JsonProperty(value="extensions") @NonNull AssertionExtensionInputs extensions) {
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        if (extensions == null) {
            throw new NullPointerException("extensions is marked non-null but is null");
        }
        this.challenge = challenge;
        this.timeout = timeout;
        this.hints = hints == null ? Collections.emptyList() : Collections.unmodifiableList(hints);
        this.rpId = rpId;
        this.allowCredentials = allowCredentials == null ? null : CollectionUtil.immutableList(allowCredentials);
        this.userVerification = userVerification;
        this.extensions = extensions;
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Optional<List<PublicKeyCredentialDescriptor>> getAllowCredentials() {
        return Optional.ofNullable(this.allowCredentials);
    }

    public Optional<UserVerificationRequirement> getUserVerification() {
        return Optional.ofNullable(this.userVerification);
    }

    public String toCredentialsGetJson() throws JsonProcessingException {
        ObjectMapper json = JacksonCodecs.json();
        ObjectNode result = json.createObjectNode();
        result.set("publicKey", (JsonNode)json.valueToTree(this));
        return json.writeValueAsString(result);
    }

    public static PublicKeyCredentialRequestOptionsBuilder.MandatoryStages builder() {
        return new PublicKeyCredentialRequestOptionsBuilder.MandatoryStages();
    }

    @Generated
    private static AssertionExtensionInputs $default$extensions() {
        return AssertionExtensionInputs.builder().build();
    }

    @Generated
    public PublicKeyCredentialRequestOptionsBuilder toBuilder() {
        return new PublicKeyCredentialRequestOptionsBuilder().challenge(this.challenge).timeout(this.timeout).hints(this.hints).rpId(this.rpId).allowCredentials(this.allowCredentials).userVerification(this.userVerification).extensions(this.extensions);
    }

    @NonNull
    @Generated
    public ByteArray getChallenge() {
        return this.challenge;
    }

    @Generated
    public List<String> getHints() {
        return this.hints;
    }

    @Generated
    public String getRpId() {
        return this.rpId;
    }

    @NonNull
    @Generated
    public AssertionExtensionInputs getExtensions() {
        return this.extensions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicKeyCredentialRequestOptions)) {
            return false;
        }
        PublicKeyCredentialRequestOptions other = (PublicKeyCredentialRequestOptions)o;
        Optional<Long> this$timeout = this.getTimeout();
        Optional<Long> other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        ByteArray this$challenge = this.getChallenge();
        ByteArray other$challenge = other.getChallenge();
        if (this$challenge == null ? other$challenge != null : !((Object)this$challenge).equals(other$challenge)) {
            return false;
        }
        List<String> this$hints = this.getHints();
        List<String> other$hints = other.getHints();
        if (this$hints == null ? other$hints != null : !((Object)this$hints).equals(other$hints)) {
            return false;
        }
        String this$rpId = this.getRpId();
        String other$rpId = other.getRpId();
        if (this$rpId == null ? other$rpId != null : !this$rpId.equals(other$rpId)) {
            return false;
        }
        Optional<List<PublicKeyCredentialDescriptor>> this$allowCredentials = this.getAllowCredentials();
        Optional<List<PublicKeyCredentialDescriptor>> other$allowCredentials = other.getAllowCredentials();
        if (this$allowCredentials == null ? other$allowCredentials != null : !((Object)this$allowCredentials).equals(other$allowCredentials)) {
            return false;
        }
        Optional<UserVerificationRequirement> this$userVerification = this.getUserVerification();
        Optional<UserVerificationRequirement> other$userVerification = other.getUserVerification();
        if (this$userVerification == null ? other$userVerification != null : !((Object)this$userVerification).equals(other$userVerification)) {
            return false;
        }
        AssertionExtensionInputs this$extensions = this.getExtensions();
        AssertionExtensionInputs other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Long> $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        ByteArray $challenge = this.getChallenge();
        result = result * 59 + ($challenge == null ? 43 : ((Object)$challenge).hashCode());
        List<String> $hints = this.getHints();
        result = result * 59 + ($hints == null ? 43 : ((Object)$hints).hashCode());
        String $rpId = this.getRpId();
        result = result * 59 + ($rpId == null ? 43 : $rpId.hashCode());
        Optional<List<PublicKeyCredentialDescriptor>> $allowCredentials = this.getAllowCredentials();
        result = result * 59 + ($allowCredentials == null ? 43 : ((Object)$allowCredentials).hashCode());
        Optional<UserVerificationRequirement> $userVerification = this.getUserVerification();
        result = result * 59 + ($userVerification == null ? 43 : ((Object)$userVerification).hashCode());
        AssertionExtensionInputs $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PublicKeyCredentialRequestOptions(challenge=" + this.getChallenge() + ", timeout=" + this.getTimeout() + ", hints=" + this.getHints() + ", rpId=" + this.getRpId() + ", allowCredentials=" + this.getAllowCredentials() + ", userVerification=" + this.getUserVerification() + ", extensions=" + this.getExtensions() + ")";
    }

    public static class PublicKeyCredentialRequestOptionsBuilder {
        @Generated
        private ByteArray challenge;
        @Generated
        private List<String> hints;
        @Generated
        private UserVerificationRequirement userVerification;
        @Generated
        private boolean extensions$set;
        @Generated
        private AssertionExtensionInputs extensions$value;
        private Long timeout = null;
        private String rpId = null;
        private List<PublicKeyCredentialDescriptor> allowCredentials = null;

        public PublicKeyCredentialRequestOptionsBuilder timeout(@NonNull Optional<Long> timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            this.timeout = timeout.orElse(null);
            return this;
        }

        private PublicKeyCredentialRequestOptionsBuilder timeout(Long timeout) {
            return this.timeout(Optional.ofNullable(timeout));
        }

        public PublicKeyCredentialRequestOptionsBuilder timeout(long timeout) {
            return this.timeout(Optional.of(timeout));
        }

        public PublicKeyCredentialRequestOptionsBuilder hints(String ... hints) {
            if (hints == null) {
                throw new NullPointerException("hints is marked non-null but is null");
            }
            this.hints = Arrays.asList(hints);
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder hints(PublicKeyCredentialHint ... hints) {
            if (hints == null) {
                throw new NullPointerException("hints is marked non-null but is null");
            }
            return this.hints((String[])Arrays.stream(hints).map(PublicKeyCredentialHint::getValue).toArray(String[]::new));
        }

        public PublicKeyCredentialRequestOptionsBuilder hints(@NonNull List<String> hints) {
            if (hints == null) {
                throw new NullPointerException("hints is marked non-null but is null");
            }
            this.hints = hints;
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder rpId(@NonNull Optional<String> rpId) {
            if (rpId == null) {
                throw new NullPointerException("rpId is marked non-null but is null");
            }
            return this.rpId((String)rpId.orElse(null));
        }

        public PublicKeyCredentialRequestOptionsBuilder rpId(String rpId) {
            this.rpId = rpId;
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder allowCredentials(@NonNull Optional<List<PublicKeyCredentialDescriptor>> allowCredentials) {
            if (allowCredentials == null) {
                throw new NullPointerException("allowCredentials is marked non-null but is null");
            }
            return this.allowCredentials((List<PublicKeyCredentialDescriptor>)allowCredentials.orElse(null));
        }

        public PublicKeyCredentialRequestOptionsBuilder allowCredentials(List<PublicKeyCredentialDescriptor> allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        @Generated
        PublicKeyCredentialRequestOptionsBuilder() {
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder challenge(@NonNull ByteArray challenge) {
            if (challenge == null) {
                throw new NullPointerException("challenge is marked non-null but is null");
            }
            this.challenge = challenge;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder userVerification(UserVerificationRequirement userVerification) {
            this.userVerification = userVerification;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder extensions(@NonNull AssertionExtensionInputs extensions) {
            if (extensions == null) {
                throw new NullPointerException("extensions is marked non-null but is null");
            }
            this.extensions$value = extensions;
            this.extensions$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptions build() {
            AssertionExtensionInputs extensions$value = this.extensions$value;
            if (!this.extensions$set) {
                extensions$value = PublicKeyCredentialRequestOptions.$default$extensions();
            }
            return new PublicKeyCredentialRequestOptions(this.challenge, this.timeout, this.hints, this.rpId, this.allowCredentials, this.userVerification, extensions$value);
        }

        @Generated
        public String toString() {
            return "PublicKeyCredentialRequestOptions.PublicKeyCredentialRequestOptionsBuilder(challenge=" + this.challenge + ", timeout=" + this.timeout + ", hints=" + this.hints + ", rpId=" + this.rpId + ", allowCredentials=" + this.allowCredentials + ", userVerification=" + (Object)((Object)this.userVerification) + ", extensions$value=" + this.extensions$value + ")";
        }

        public static class MandatoryStages {
            private final PublicKeyCredentialRequestOptionsBuilder builder = new PublicKeyCredentialRequestOptionsBuilder();

            public PublicKeyCredentialRequestOptionsBuilder challenge(ByteArray challenge) {
                return this.builder.challenge(challenge);
            }
        }
    }
}

