/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.dtolayer.dtos.IpFilterDTO;
import com.alphaserve.twofactor.core.model.IpValidator;
import com.alphaserve.twofactor.core.model.exceptions.ParseIPException;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class WhitelistValidation
implements Validator<IpFilterDTO> {
    @ComponentImport
    private I18nResolver i18nResolver;

    @Inject
    public WhitelistValidation(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Override
    public ValidationResult validate(IpFilterDTO ipFilterDTO) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        try {
            if (!IpValidator.validateAddress(ipFilterDTO.getIpConfig())) {
                validationResult.addError("auth.text.whitelist-ip-error");
            }
        }
        catch (ParseIPException e) {
            validationResult.addError("auth.text.whitelist-ip-error");
        }
        return validationResult;
    }
}

