/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.dtolayer.dtos.TOTPLoginDTO;
import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.services.entities.SecretKeyService;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ReserveCodeValidation
implements Validator<TOTPLoginDTO> {
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final Auth2FAService auth2FAService;
    private final UserService userService;
    private final SecretKeyService secretKeyService;

    @Inject
    public ReserveCodeValidation(I18nResolver i18nResolver, Auth2FAService auth2FAService, UserService userService, SecretKeyService secretKeyService) {
        this.i18nResolver = i18nResolver;
        this.auth2FAService = auth2FAService;
        this.userService = userService;
        this.secretKeyService = secretKeyService;
    }

    @Override
    public ValidationResult validate(TOTPLoginDTO TOTPLoginDTO2) {
        return this.validate(TOTPLoginDTO2, false);
    }

    public ValidationResult validate(TOTPLoginDTO TOTPLoginDTO2, boolean isReadOnlyMode) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        Auth2FA auth2fa = this.auth2FAService.getByUserKey(this.userService.getUserProfile().getUserKey());
        if (!this.secretKeyService.reserveSecretPass(auth2fa, TOTPLoginDTO2.getCode(), isReadOnlyMode)) {
            validationResult.addError("auth.text.auth-wrong-code");
        }
        return validationResult;
    }
}

