/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.dtolayer.dtos.TOTPMobileLoginDTO;
import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.security.Totp;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserProfile;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class MobileSecretKeyValidation
implements Validator<TOTPMobileLoginDTO> {
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final Auth2FAService auth2FAService;
    private final ConfigurationService configurationService;
    private final UserService userService;

    @Inject
    public MobileSecretKeyValidation(I18nResolver i18nResolver, Auth2FAService auth2FAService, ConfigurationService configurationService, UserService userService) {
        this.i18nResolver = i18nResolver;
        this.auth2FAService = auth2FAService;
        this.configurationService = configurationService;
        this.userService = userService;
    }

    @Override
    public ValidationResult validate(TOTPMobileLoginDTO totpMobileLoginDTO) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        UserProfile userProfile = this.userService.getUserProfile(totpMobileLoginDTO.getUsername());
        if (Objects.isNull(userProfile)) {
            validationResult.addError("auth.text.user-auth-deleted-error");
            return validationResult;
        }
        Auth2FA auth2fa = this.auth2FAService.getByUserKey(userProfile.getUserKey());
        if (!this.isValid(auth2fa, this.parseCode(totpMobileLoginDTO.getCode()))) {
            validationResult.addError("auth.text.auth-wrong-code");
        }
        return validationResult;
    }

    private boolean isValid(Auth2FA auth2FA, int code) {
        Totp totpConfig = this.getTotpConfig();
        try {
            if (totpConfig.validateCurrentNumber(auth2FA.getKey(), code, 0, this.configurationService.getAuthDuoEnable())) {
                return true;
            }
        }
        catch (GeneralSecurityException e) {
            return false;
        }
        return false;
    }

    private Totp getTotpConfig() {
        return Totp.build(this.configurationService.getTimeStep(), this.configurationService.getAuthLabel(), this.configurationService.getAuthKeySize());
    }

    private int parseCode(String code) {
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

