/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.dtolayer.dtos.MobileLoginDTO;
import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.stereotype.Component;

@Named
@Component
public class MobileLoginValidation
implements Validator<MobileLoginDTO> {
    public static String MOBILE = "AtlassianMobileApp";
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final Auth2FAService auth2FAService;

    @Inject
    public MobileLoginValidation(I18nResolver i18nResolver, Auth2FAService auth2FAService) {
        this.i18nResolver = i18nResolver;
        this.auth2FAService = auth2FAService;
    }

    @Override
    public ValidationResult validate(MobileLoginDTO mobileLoginDTO) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        if (!MOBILE.equals(mobileLoginDTO.getUserAgent())) {
            validationResult.addError("auth.text.auth.not.mobile.device");
        }
        Auth2FA byUsername = this.auth2FAService.getByUsername(mobileLoginDTO.getUsername());
        return validationResult;
    }
}

