/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpSession;

@Named
public class LoggedTwoFactorValidation
implements Validator<HttpSession> {
    @ComponentImport
    private I18nResolver i18nResolver;
    private final AuthLoginService authLoginService;

    @Inject
    public LoggedTwoFactorValidation(I18nResolver i18nResolver, AuthLoginService authLoginService) {
        this.i18nResolver = i18nResolver;
        this.authLoginService = authLoginService;
    }

    @Override
    public ValidationResult validate(HttpSession session) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        if (!this.authLoginService.isLogged(session)) {
            validationResult.addError("auth.text.not.permissions");
        }
        return validationResult;
    }
}

