/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.Plugin2FACoreContext;
import com.alphaserve.twofactor.core.utils.UrlUtils;
import com.alphaserve.twofactor.core.validation.ResourceValidation;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;

@Named
public class HttpResourceUrlValidation {
    private final ResourceValidation[] validationSequence = new ResourceValidation[]{(method, url) -> method.equals("POST") && url.equals(pluginContext.getWrmResources()), (method, url) -> method.equals("GET") && url.contains(pluginContext.getDefaultResourcePath())};

    @Inject
    public HttpResourceUrlValidation(Plugin2FACoreContext pluginContext) {
    }

    public boolean isResourceRequest(HttpServletRequest request) {
        String method = request.getMethod();
        String url = UrlUtils.normalizeURL(request.getRequestURI());
        for (ResourceValidation validation : this.validationSequence) {
            if (!validation.test(method, url)) continue;
            return true;
        }
        return false;
    }
}

