/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.dtolayer.dtos.BulkResetDTO;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Named
@Component
public class BulkResetValidation
implements Validator<BulkResetDTO> {
    @ComponentImport
    private final I18nResolver i18nResolver;

    @Inject
    public BulkResetValidation(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Override
    public ValidationResult validate(BulkResetDTO bulkResetDTO) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        if (StringUtils.isBlank(bulkResetDTO.getType())) {
            validationResult.addError("auth.text.bulk-reset-empty-field");
            return validationResult;
        }
        if (bulkResetDTO.getType().equals("resetGroups") && (Objects.isNull(bulkResetDTO.getGroups()) || bulkResetDTO.getGroups().length == 0)) {
            validationResult.addError("auth.text.error-bulk-reset-zero-groups");
            return validationResult;
        }
        if (bulkResetDTO.getType().equals("restAllExceptGroups") && (Objects.isNull(bulkResetDTO.getExpectGroups()) || bulkResetDTO.getExpectGroups().length == 0)) {
            validationResult.addError("auth.text.error-bulk-reset-except-zero-groups");
            return validationResult;
        }
        return validationResult;
    }
}

