/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.net.InetAddresses;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class AppIdValidation
implements Validator<String> {
    @ComponentImport
    private I18nResolver i18nResolver;

    @Inject
    public AppIdValidation(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Override
    public ValidationResult validate(String appId) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        if (!appId.contains(":")) {
            validationResult.addError("auth.text.error-not-valid-url");
        } else if (appId.startsWith("http:") && !appId.startsWith("http://localhost")) {
            validationResult.addError("auth.text.error-https");
        } else if (appId.startsWith("https://")) {
            try {
                URI url = new URI(appId);
                if (this.checkNotIpAddress(url)) {
                    validationResult.addError("auth.text.error-ip-instead-of-domain");
                }
            }
            catch (URISyntaxException e) {
                validationResult.addError("auth.text.error-ip-instead-of-domain");
            }
        }
        return validationResult;
    }

    private boolean checkNotIpAddress(URI url) {
        return InetAddresses.isInetAddress(url.getAuthority()) || url.getHost() != null && InetAddresses.isInetAddress(url.getHost());
    }
}

