/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UrlUtils.class);

    public static String normalizeURL(String url) {
        if (url.startsWith("http")) {
            try {
                URL url1 = new URL(url);
                return url1.getProtocol() + "://" + url1.getHost() + (url1.getPort() == -1 ? "" : ":" + url1.getPort()) + UrlUtils.normalize(url1.getPath() + (Objects.isNull(url1.getQuery()) ? "" : "?" + url1.getQuery()));
            }
            catch (MalformedURLException e) {
                return "";
            }
        }
        return UrlUtils.normalize(url);
    }

    private static String normalize(String url) {
        String[] split = url.split("\\.\\./");
        if (split.length > 1) {
            String start = split[0];
            int count = 0;
            if (start.endsWith(".")) {
                ++count;
            }
            for (int i = 1; i < split.length; ++i) {
                if (split[i].startsWith(".")) {
                    count += 2;
                }
                if (count == 0) {
                    int lastIndex = start.lastIndexOf("/", start.length() - 2);
                    if (lastIndex == -1) continue;
                    start = start.substring(0, lastIndex + 1) + split[i];
                    continue;
                }
                --count;
            }
            if (start.contains("\\.\\./")) {
                return UrlUtils.normalize(start);
            }
            return start;
        }
        return url;
    }

    public static String encodeUrl(String url) {
        URLCodec urlCodec = new URLCodec();
        try {
            return urlCodec.encode(url);
        }
        catch (EncoderException e) {
            return url;
        }
    }

    public static String getTargetURL(HttpServletRequest request, String baseUrl) {
        String url = UrlUtils.normalizeURL(UrlUtils.getTargetUrlRelatedToInstance(request, baseUrl));
        String queryString = request.getQueryString();
        if (StringUtils.isBlank(queryString) || UrlUtils.isServiceDeskProjectUrl(request)) {
            return UrlUtils.encodeUrl(url);
        }
        return UrlUtils.encodeUrl(url + "?" + queryString);
    }

    private static String getTargetUrlRelatedToInstance(HttpServletRequest request, String baseUrl) {
        String url = UrlUtils.isServiceDeskProjectUrl(request) ? UrlUtils.getOuterUrl(request) : (UrlUtils.isBitbucketUrl(request, baseUrl) ? UrlUtils.getOuterBitbucketUrl(request, baseUrl) : request.getRequestURL().toString());
        return url;
    }

    private static boolean isBitbucketUrl(HttpServletRequest request, String baseUrl) {
        return request.getRequestURI().startsWith(baseUrl + "/mvc/");
    }

    private static String getOuterBitbucketUrl(HttpServletRequest request, String baseUrl) {
        return request.getRequestURL().toString().replaceFirst(baseUrl + "/mvc/", baseUrl + "/");
    }

    private static String getOuterUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        String serviceDeskUrl = "secure/ProjectAppAction.jspa";
        return url.replace(serviceDeskUrl, "projects/" + request.getParameter("projectKey") + "/" + request.getParameter("page"));
    }

    private static boolean isServiceDeskProjectUrl(HttpServletRequest request) {
        String serviceDeskUrl;
        String url = request.getRequestURL().toString();
        return url.indexOf(serviceDeskUrl = "secure/ProjectAppAction.jspa") == url.length() - serviceDeskUrl.length();
    }

    public static String getDomain(String baseUrl) {
        String domain;
        try {
            URI uri = new URI(baseUrl);
            domain = uri.getHost();
        }
        catch (URISyntaxException e) {
            domain = "";
        }
        return domain;
    }

    public static String getRequestPath(String data) {
        try {
            return new URL(data).getPath();
        }
        catch (MalformedURLException exception) {
            return data;
        }
    }

    public static String concatenateUrlParts(String prefix, String url) {
        boolean urlStartsWithResult = url.startsWith("/");
        boolean baseUrlEndsWithResult = prefix.endsWith("/");
        if (baseUrlEndsWithResult && urlStartsWithResult) {
            String trueUrl = url.substring(1);
            return prefix + trueUrl;
        }
        if (baseUrlEndsWithResult || urlStartsWithResult) {
            return prefix + url;
        }
        return prefix + '/' + url;
    }
}

