/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.rest.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.CredentialDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.CredentialName;
import com.alphaserve.twofactor.core.model.AuthType;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.LoggerService;
import com.alphaserve.twofactor.core.services.LoginActionService;
import com.alphaserve.twofactor.core.services.PluginInfoService;
import com.alphaserve.twofactor.core.services.PublicKeyService;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.services.rest.WebAuthnRestService;
import com.alphaserve.twofactor.core.utils.AppIdUtils;
import com.alphaserve.twofactor.core.validation.AppIdValidation;
import com.alphaserve.twofactor.core.validation.LoggedTwoFactorValidation;
import com.alphaserve.twofactor.core.validation.User2faEnabledValidation;
import com.alphaserve.twofactor.core.validation.XsrfTokenValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.exception.AssertionFailedException;
import com.yubico.webauthn.exception.RegistrationFailedException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Named
@Component
public class WebAuthnRestServiceImpl
implements WebAuthnRestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebAuthnRestServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(WebAuthnRestService.class);
    private PublicKeyService publicKeyService;
    private UserService userService;
    private Validator<CredentialName> validator;
    private LoggerService loggerService;
    private PluginInfoService pluginService;
    private LoginActionService loginActionService;
    private ConfigurationService configurationService;
    private final XsrfTokenValidator xsrfTokenValidator;
    private final LoggedTwoFactorValidation loggedTwoFactorValidation;
    private final AppIdValidation appIdValidation;
    private final User2faEnabledValidation user2faEnabledValidation;

    @Inject
    public WebAuthnRestServiceImpl(PublicKeyService publicKeyService, UserService userService, Validator<CredentialName> validator, LoggerService loggerService, PluginInfoService pluginService, LoginActionService loginActionService, ConfigurationService configurationService, XsrfTokenValidator xsrfTokenValidator, LoggedTwoFactorValidation loggedTwoFactorValidation, AppIdValidation appIdValidation, User2faEnabledValidation user2faEnabledValidation) {
        this.publicKeyService = publicKeyService;
        this.userService = userService;
        this.validator = validator;
        this.loggerService = loggerService;
        this.pluginService = pluginService;
        this.loginActionService = loginActionService;
        this.configurationService = configurationService;
        this.xsrfTokenValidator = xsrfTokenValidator;
        this.loggedTwoFactorValidation = loggedTwoFactorValidation;
        this.appIdValidation = appIdValidation;
        this.user2faEnabledValidation = user2faEnabledValidation;
    }

    @Override
    public Response getPublicKey(HttpServletRequest request, HttpServletResponse response, CredentialName dto) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        if (!this.configurationService.getAuthU2FEnable()) {
            return this.badRequest();
        }
        validationResult = this.appIdValidation.validate(AppIdUtils.getAppId(request));
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        validationResult = this.validator.validate(dto);
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        try {
            return this.ok(this.publicKeyService.getPublicKey(request, dto.getName()));
        }
        catch (JsonProcessingException e) {
            logger.error("Error during convert to JSON", e);
            return this.badRequest();
        }
    }

    @Override
    public Response finishRegistration(HttpServletRequest request, HttpServletResponse httpServletResponse, String response) {
        return this.finishRegistration(request, httpServletResponse, response, false);
    }

    @Override
    public Response finishRegistration(HttpServletRequest request, HttpServletResponse httpServletResponse, String response, boolean isReadOnlyMode) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, httpServletResponse);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        if (!this.configurationService.getAuthU2FEnable()) {
            return this.badRequest();
        }
        try {
            if (this.publicKeyService.finishRegistration(request, response, isReadOnlyMode)) {
                return this.ok("webauth.register.credential.added");
            }
        }
        catch (IOException e) {
            logger.error("Error parse response JSON during registration", e);
        }
        catch (RegistrationFailedException e) {
            logger.error("Wrong arguments during registration", e);
        }
        return this.badRequest();
    }

    @Override
    public Response initLogin(HttpServletRequest request, HttpServletResponse response) {
        return this.initLogin(request, response, false);
    }

    @Override
    public Response initLogin(HttpServletRequest request, HttpServletResponse response, boolean isReadOnlyMode) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.appIdValidation.validate(AppIdUtils.getAppId(request));
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        String username = this.userService.getUserProfile().getUsername();
        if (!this.configurationService.getAuthU2FEnable()) {
            return this.badRequest();
        }
        if (this.userService.isUserHasDevice(username)) {
            try {
                return this.ok(this.publicKeyService.initAssertion(request, username));
            }
            catch (JsonProcessingException e) {
                logger.error("Error during convert AssertionRequest to JSON", e);
                this.loggerService.addLog(LogActionType.PASS_2FA_FAILED, request, username);
            }
        }
        return this.badRequest();
    }

    @Override
    public Response finishLogin(HttpServletRequest request, HttpServletResponse response, String responseJson, boolean remember) {
        return this.finishLogin(request, response, responseJson, remember, false);
    }

    @Override
    public Response finishLogin(HttpServletRequest request, HttpServletResponse response, String responseJson, boolean remember, boolean isReadOnlyMode) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        if (!this.configurationService.getAuthU2FEnable()) {
            return this.badRequest();
        }
        validationResult = this.user2faEnabledValidation.validate();
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        try {
            AssertionResult assertionResult = this.publicKeyService.finishAssertion(request, responseJson);
            if (assertionResult.isSuccess()) {
                UserProfile userProfile = this.userService.getUserProfile();
                this.loginActionService.login(userProfile, request, response, AuthType.U2F_DEVICE, remember);
                return this.ok();
            }
        }
        catch (IOException e) {
            logger.error("Error parse response JSON during login", e);
            this.loggerService.addLog(LogActionType.PASS_2FA_FAILED, request, "UNKNOWN");
        }
        catch (AssertionFailedException e) {
            logger.error("Wrong arguments during login", e);
            this.loggerService.addLog(LogActionType.PASS_2FA_FAILED, request, "UNKNOWN");
        }
        catch (NullPointerException e) {
            logger.error(e.getMessage(), e);
            this.loggerService.addLog(LogActionType.PASS_2FA_FAILED, request, "UNKNOWN");
        }
        return this.badRequest();
    }

    @Override
    public Response geUserCredentials(HttpServletRequest request, HttpServletResponse response) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        List<CredentialDTO> credentialDTOS = this.userService.geUserCredentialsDTO();
        if (Objects.nonNull(credentialDTOS)) {
            try {
                return this.ok(mapper.writeValueAsString(credentialDTOS));
            }
            catch (JsonProcessingException e) {
                logger.error("Error parse response JSON during get user credentials", e);
            }
            catch (NullPointerException e) {
                logger.error(e.getMessage(), e);
            }
        }
        return this.badRequest();
    }

    @Override
    public Response deleteUserCredential(HttpServletRequest request, HttpServletResponse response, String id) {
        return this.deleteUserCredential(request, response, id, false);
    }

    @Override
    public Response deleteUserCredential(HttpServletRequest request, HttpServletResponse response, String id, boolean isReadOnlyMode) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.loggedTwoFactorValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        try {
            if (this.userService.deleteCredential(request, id, isReadOnlyMode)) {
                return this.ok();
            }
            logger.error("Error during delete credential, user with credential id #" + id + " not found");
        }
        catch (NullPointerException e) {
            logger.error(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Server error", e);
        }
        return this.badRequest();
    }

    @Override
    public Response isAllowed() {
        if (!this.pluginService.isPluginLicensed()) {
            return this.badRequest();
        }
        return this.ok();
    }

    private Response getBadValidationResponse(ValidationResult validationResult) {
        try {
            return this.badRequest(mapper.writeValueAsString(validationResult.getErrors()));
        }
        catch (JsonProcessingException e) {
            log.error("Can't convert errors to JSON", e);
            return this.badRequest();
        }
    }
}

