/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.rest.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.PaginationWrapper;
import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionFilterDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LoggerDateDTO;
import com.alphaserve.twofactor.core.model.LoggerDate;
import com.alphaserve.twofactor.core.services.LoggerService;
import com.alphaserve.twofactor.core.services.export.ExportService;
import com.alphaserve.twofactor.core.services.rest.LoggerRestService;
import com.alphaserve.twofactor.core.validation.AdminPermittedValidation;
import com.alphaserve.twofactor.core.validation.XsrfTokenValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Named
@Component
public class LoggerRestServiceImpl
implements LoggerRestService {
    private final LoggerService loggerService;
    private final AdminPermittedValidation adminPermittedValidation;
    private final Validator<LoggerDateDTO> loggerDateDTOValidator;
    private final ExportService exportService;
    private final XsrfTokenValidator xsrfTokenValidator;
    private static final Logger logger = LoggerFactory.getLogger(LoggerRestService.class);

    @Inject
    public LoggerRestServiceImpl(LoggerService loggerService, AdminPermittedValidation adminPermittedValidation, Validator<LoggerDateDTO> loggerDateDTOValidator, ExportService exportService, XsrfTokenValidator xsrfTokenValidator) {
        this.loggerService = loggerService;
        this.adminPermittedValidation = adminPermittedValidation;
        this.loggerDateDTOValidator = loggerDateDTOValidator;
        this.exportService = exportService;
        this.xsrfTokenValidator = xsrfTokenValidator;
    }

    @Override
    public Response getPage(HttpServletRequest request, HttpServletResponse response, LogActionFilterDTO filterDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.adminPermittedValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        PaginationWrapper<LogActionDTO> page = this.loggerService.getPage(filterDTO);
        try {
            return this.ok(mapper.writeValueAsString(page));
        }
        catch (JsonProcessingException e) {
            logger.error("Can't convert PaginationWrapper to JSON", e);
            return this.badRequest();
        }
    }

    @Override
    public Response deleteLogs(HttpServletRequest request, HttpServletResponse response, LoggerDateDTO loggerDateDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.adminPermittedValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        validationResult = this.loggerDateDTOValidator.validate(loggerDateDTO);
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        this.loggerService.deleteLogs(LoggerDate.valueOf(loggerDateDTO.getLoggerDate()));
        return this.ok();
    }

    @Override
    public Response exportLogs(HttpServletRequest request, LogActionFilterDTO filterDTO, String type) {
        ValidationResult validationResult = this.adminPermittedValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        List<LogActionDTO> logs = this.loggerService.getAllLogs(filterDTO);
        ByteArrayOutputStream output = this.exportService.export(logs, type);
        return Response.ok((Object)output.toByteArray(), (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=\"" + this.exportService.generateFileName(filterDTO, logs.size(), type) + "\"")).build();
    }

    private Response getBadValidationResponse(ValidationResult validationResult) {
        try {
            return this.badRequest(mapper.writeValueAsString(validationResult.getErrors()));
        }
        catch (JsonProcessingException e) {
            logger.error("Can't convert errors to JSON", e);
            return this.badRequest();
        }
    }
}

