/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.rest.impl;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.IpFilterDTO;
import com.alphaserve.twofactor.core.model.entities.IpFilter;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.services.rest.IpWhitelistRestService;
import com.alphaserve.twofactor.core.validation.AdminPermittedValidation;
import com.alphaserve.twofactor.core.validation.XsrfTokenValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.fasterxml.jackson.core.JsonProcessingException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IpWhitelistRestServiceImpl
implements IpWhitelistRestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpWhitelistRestServiceImpl.class);
    private Validator<IpFilterDTO> whitelistValidator;
    private IpFilterService ipFilterService;
    private DoForwardConverter<IpFilter, IpFilterDTO> ipFilterConverter;
    private AdminPermittedValidation adminPermittedValidation;
    private final XsrfTokenValidator xsrfTokenValidator;

    @Inject
    public IpWhitelistRestServiceImpl(Validator<IpFilterDTO> whitelistValidator, IpFilterService ipFilterService, DoForwardConverter<IpFilter, IpFilterDTO> ipFilterConverter, AdminPermittedValidation adminPermittedValidation, XsrfTokenValidator xsrfTokenValidator) {
        this.whitelistValidator = whitelistValidator;
        this.ipFilterService = ipFilterService;
        this.ipFilterConverter = ipFilterConverter;
        this.adminPermittedValidation = adminPermittedValidation;
        this.xsrfTokenValidator = xsrfTokenValidator;
    }

    @Override
    public Response add(HttpServletRequest request, HttpServletResponse response, IpFilterDTO ipFilterDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.adminPermittedValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        validationResult = this.whitelistValidator.validate(ipFilterDTO);
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        IpFilter newIpFilter = this.ipFilterService.add(ipFilterDTO);
        try {
            return this.ok(mapper.writeValueAsString(this.ipFilterConverter.doForward(newIpFilter)));
        }
        catch (JsonProcessingException e) {
            log.error("Can't convert IpFilterDTO to JSON", e);
            return this.badRequest();
        }
    }

    @Override
    public Response delete(HttpServletRequest request, HttpServletResponse response, IpFilterDTO ipFilterDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.adminPermittedValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        this.ipFilterService.deleteById(ipFilterDTO.getId());
        return this.ok();
    }

    private Response getBadValidationResponse(ValidationResult validationResult) {
        try {
            return this.badRequest(mapper.writeValueAsString(validationResult.getErrors()));
        }
        catch (JsonProcessingException e) {
            log.error("Can't convert errors to JSON", e);
            return this.badRequest();
        }
    }
}

