/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.dao.TwoFAUsersDao;
import com.alphaserve.twofactor.core.dtolayer.dtos.PersonDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.TwoFAPage;
import com.alphaserve.twofactor.core.dtolayer.dtos.TwoFAPageRequest;
import com.alphaserve.twofactor.core.dtolayer.dtos.TwoFAUsersRequestDTO;
import com.alphaserve.twofactor.core.services.TwoFAUserService;
import com.alphaserve.twofactor.core.services.strategy.pagination.TwoFAPaginationStrategy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.poi.util.StringUtil;

@Named
public class TwoFAUserServiceImpl
implements TwoFAUserService {
    private final TwoFAUsersDao twoFAUsersDao;
    private final TwoFAPaginationStrategy twoFAPaginationStrategy;

    @Inject
    public TwoFAUserServiceImpl(TwoFAUsersDao twoFAUsersDao, TwoFAPaginationStrategy twoFAPaginationStrategy) {
        this.twoFAUsersDao = twoFAUsersDao;
        this.twoFAPaginationStrategy = twoFAPaginationStrategy;
    }

    @Override
    public TwoFAPage<PersonDTO> getRequested2FAUsers(TwoFAUsersRequestDTO requestDTO) {
        TwoFAPageRequest pageRequest = this.twoFAPaginationStrategy.createPageRequest(requestDTO);
        if (StringUtil.isNotBlank(requestDTO.getSearchValue())) {
            if (requestDTO.getSearchBy() == TwoFAUsersRequestDTO.SearchBy.USER_NAME) {
                return this.twoFAUsersDao.findByName(requestDTO.getSearchValue(), pageRequest);
            }
            return this.twoFAUsersDao.findByEmail(requestDTO.getSearchValue(), pageRequest);
        }
        switch (requestDTO.getUserState()) {
            case ONLY_ACTIVE: {
                return this.twoFAUsersDao.findActiveUsers(pageRequest);
            }
            case ONLY_INACTIVE: {
                return this.twoFAUsersDao.findInactiveUsers(pageRequest);
            }
        }
        return this.twoFAUsersDao.findUsers(pageRequest);
    }
}

