/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.BulkResetDTO;
import com.alphaserve.twofactor.core.model.AuthType;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.model.entities.cache.wraper.Auth2FACacheWrapper;
import com.alphaserve.twofactor.core.model.exceptions.QRCodeOnlyAuthorizedException;
import com.alphaserve.twofactor.core.security.Totp;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.LoginActionService;
import com.alphaserve.twofactor.core.services.TotpService;
import com.alphaserve.twofactor.core.services.U2fService;
import com.alphaserve.twofactor.core.services.UserActionService;
import com.alphaserve.twofactor.core.services.cache.Auth2FACacheManager;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.services.entities.CredentialService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.services.entities.LoggerActionService;
import com.alphaserve.twofactor.core.services.entities.RememberMeService;
import com.alphaserve.twofactor.core.services.entities.SecretKeyService;
import com.alphaserve.twofactor.core.services.entities.U2FDeviceService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.zxing.WriterException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named
public class TotpServiceImpl
implements TotpService {
    @ComponentImport
    private final UserManager userManager;
    private final Auth2FAService auth2FAService;
    private final SecretKeyService secretKeyService;
    private final ConfigurationService configurationService;
    private final LoginActionService loginActionService;
    private final U2fService u2fService;
    private final LoggerActionService loggerActionService;
    private final IpFilterService ipFilterService;
    private final U2FDeviceService u2FDeviceService;
    private final UserActionService userActionService;
    private final CredentialService credentialService;
    private final Auth2FACacheManager auth2FACacheManager;
    private final RememberMeService rememberMeService;

    @Inject
    public TotpServiceImpl(@Qualifier(value="userManager") UserManager userManager, Auth2FAService auth2FAService, SecretKeyService secretKeyService, ConfigurationService configurationService, LoginActionService loginActionService, U2fService u2fService, LoggerActionService loggerActionService, IpFilterService ipFilterService, U2FDeviceService u2FDeviceService, UserActionService userActionService, CredentialService credentialService, Auth2FACacheManager auth2FACacheManager, RememberMeService rememberMeService) {
        this.userManager = userManager;
        this.auth2FAService = auth2FAService;
        this.secretKeyService = secretKeyService;
        this.configurationService = configurationService;
        this.loginActionService = loginActionService;
        this.u2fService = u2fService;
        this.loggerActionService = loggerActionService;
        this.ipFilterService = ipFilterService;
        this.u2FDeviceService = u2FDeviceService;
        this.userActionService = userActionService;
        this.credentialService = credentialService;
        this.auth2FACacheManager = auth2FACacheManager;
        this.rememberMeService = rememberMeService;
    }

    @Override
    public void loginReserveCode(UserProfile userProfile, HttpServletRequest req, HttpServletResponse resp, String code) {
        this.loginActionService.login(userProfile, req, resp, AuthType.TOTP_RESERVE_KEY, false);
    }

    @Override
    public void login(UserProfile userProfile, HttpServletRequest req, HttpServletResponse resp, boolean rememberMe, int code) {
        this.loginActionService.login(userProfile, req, resp, AuthType.TOTP_SECURITY_KEY, rememberMe);
    }

    @Override
    public String getQRImageUrl(UserProfile userProfile) throws IOException, WriterException, QRCodeOnlyAuthorizedException {
        Totp totpConfig = this.getTotpConfig();
        Auth2FA auth2fa = this.auth2FAService.getByUserKey(userProfile.getUserKey());
        if (auth2fa.getConfirmed()) {
            throw new QRCodeOnlyAuthorizedException();
        }
        String email = userProfile.getEmail();
        return totpConfig.qrImageUrl(auth2fa.getKey(), email);
    }

    @Override
    public void revoke(UserProfile userProfile, HttpServletRequest request) {
        Auth2FA byUserId = this.auth2FAService.getByUserKey(userProfile.getUserKey());
        this.auth2FAService.delete(byUserId);
        this.secretKeyService.deleteList(this.secretKeyService.getByAuth(byUserId));
        this.loggerActionService.add(userProfile.getUsername(), LogActionType.REVOKE, this.ipFilterService.getClientIpAddress(request));
    }

    @Override
    public void enable(Auth2FA auth2FA, int code) {
        if (!auth2FA.getConfirmed() && !auth2FA.getActive()) {
            this.auth2FAService.enable2fa(auth2FA);
        }
    }

    @Override
    public void enable(UserProfile userProfile, int code) {
        Auth2FA auth2FA = this.auth2FAService.getByUserKey(userProfile.getUserKey());
        this.enable(auth2FA, code);
    }

    @Override
    public Auth2FA create(UserProfile userProfile) {
        Totp totpConfig = this.getTotpConfig();
        Auth2FA auth2fa = this.auth2FAService.add(userProfile.getUserKey().getStringValue(), totpConfig.generateBase32Secret(), false);
        this.secretKeyService.generateUserSecretKeys(auth2fa, totpConfig);
        return auth2fa;
    }

    @Override
    public Auth2FA getByUser(UserProfile userProfile) {
        Totp totpConfig = this.getTotpConfig();
        Auth2FA auth2fa = this.auth2FAService.getByUserKey(userProfile.getUserKey());
        if (Objects.isNull(auth2fa)) {
            auth2fa = this.create(userProfile);
        }
        int currentAuthKeySize = this.configurationService.getAuthKeySize();
        if (!auth2fa.getActive() && auth2fa.getKey().length() != currentAuthKeySize) {
            String newKey = totpConfig.generateBase32Secret();
            auth2fa.setKey(newKey);
            auth2fa.save();
            this.auth2FACacheManager.cacheEntity(auth2fa.getUserKey(), new Auth2FACacheWrapper(auth2fa));
            totpConfig.setKeySize(currentAuthKeySize);
        }
        return auth2fa;
    }

    @Override
    public void finishRegistration(UserProfile userProfile) {
        if (this.auth2FAService.isUserAllowedToFinishRegistration(userProfile)) {
            this.auth2FAService.finishRegistration(userProfile);
        }
    }

    @Override
    public void reset(UserProfile userProfile, HttpServletRequest request) {
        Auth2FA auth2FA = this.auth2FAService.getByUserKey(userProfile.getUserKey());
        if (Objects.isNull(auth2FA)) {
            return;
        }
        this.auth2FAService.delete(auth2FA);
        this.secretKeyService.deleteList(this.secretKeyService.getByAuth(auth2FA));
        this.u2fService.reset(userProfile);
        this.credentialService.deleteByUserKey(auth2FA.getUserKey());
        this.rememberMeService.deleteRememberedUserClusterByUserKey(request.getSession(), userProfile.getUserKey().getStringValue());
    }

    @Override
    public void reset(String username, HttpServletRequest request) {
        UserProfile applicationUser = this.userManager.getUserProfile(username);
        if (Objects.isNull(applicationUser)) {
            return;
        }
        this.reset(applicationUser, request);
        this.loggerActionService.add(username, LogActionType.RESET_BY_ADMIN, this.ipFilterService.getClientIpAddress(request));
    }

    @Override
    public void bulkReset(BulkResetDTO bulkResetDTO, HttpServletRequest request) {
        switch (bulkResetDTO.getType()) {
            case "resetAll": {
                this.deleteAll(request);
                break;
            }
            case "resetGroups": {
                this.deleteByGroups(bulkResetDTO.getGroups(), request);
                break;
            }
            case "restAllExceptGroups": {
                this.deleteByExcludeGroups(bulkResetDTO.getExpectGroups(), request);
            }
        }
    }

    private void deleteAll(HttpServletRequest request) {
        List<Auth2FA> all = this.auth2FAService.getAll();
        for (Auth2FA auth2FA : all) {
            this.reset(auth2FA, request);
        }
    }

    private void reset(Auth2FA auth2FA, HttpServletRequest request) {
        if (Objects.nonNull(auth2FA) && auth2FA.getActive() && auth2FA.getConfirmed()) {
            UserProfile applicationUser = this.userManager.getUserProfile(new UserKey(auth2FA.getUserKey()));
            this.secretKeyService.deleteBy(auth2FA);
            this.auth2FAService.delete(auth2FA);
            this.u2FDeviceService.deleteByUserKey(auth2FA.getUserKey());
            this.credentialService.deleteByUserKey(auth2FA.getUserKey());
            this.rememberMeService.deleteRememberedUserClusterByUserKey(auth2FA.getUserKey());
            if (Objects.nonNull(applicationUser)) {
                this.loggerActionService.add(applicationUser.getUsername(), LogActionType.RESET_BY_ADMIN, this.ipFilterService.getClientIpAddress(request));
            }
        }
    }

    private void deleteByGroups(String[] groupsName, HttpServletRequest request) {
        for (String groupName : groupsName) {
            List<String> usersKeyByGroup = this.userActionService.findUsersKeyByGroup(groupName);
            for (String userKey : usersKeyByGroup) {
                Auth2FA byUserKey = this.auth2FAService.getByUserKey(userKey);
                this.reset(byUserKey, request);
            }
        }
    }

    private void deleteByExcludeGroups(String[] excludeGroupsName, HttpServletRequest request) {
        ArrayList<String> excludedUsers = new ArrayList<String>();
        for (String groupName : excludeGroupsName) {
            excludedUsers.addAll(this.userActionService.findUsersKeyByGroup(groupName));
        }
        Map<String, String> collect = excludedUsers.stream().distinct().collect(Collectors.toMap(a -> a, a -> a));
        List<Auth2FA> all = this.auth2FAService.getAll();
        for (Auth2FA auth2FA : all) {
            if (collect.containsKey(auth2FA.getUserKey())) continue;
            this.reset(auth2FA, request);
        }
    }

    private Totp getTotpConfig() {
        return Totp.build(this.configurationService.getTimeStep(), this.configurationService.getAuthLabel(), this.configurationService.getAuthKeySize());
    }
}

