/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.services.NTPService;
import java.io.IOException;
import java.net.InetAddress;
import javax.inject.Named;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;

@Named
public class NTPServiceImpl
implements NTPService {
    private static final int OUT_OF_SYNC_SECONDS = 10;
    private static final int MILLIS_TO_SECONDS_DIFF = 60000;
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;
    private static final String TIME_SERVER_ADDRESS = "time.google.com";

    @Override
    public long getServerDifferenceSeconds() {
        NTPUDPClient client = new NTPUDPClient();
        client.setDefaultTimeout(5000);
        try {
            client.open();
            InetAddress inetAddress = InetAddress.getByName(TIME_SERVER_ADDRESS);
            TimeInfo info = client.getTime(inetAddress);
            info.computeDetails();
            client.close();
            return info.getOffset();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean isTimeOutOfSync() {
        return Math.abs(this.getServerDifferenceSeconds() / 60000L) >= 10L;
    }
}

