/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.model.entities.cache.wraper.Auth2FACacheWrapper;
import com.alphaserve.twofactor.core.model.exceptions.ForceException;
import com.alphaserve.twofactor.core.model.exceptions.LockedException;
import com.alphaserve.twofactor.core.security.AuthFilterManager;
import com.alphaserve.twofactor.core.security.FilterState;
import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.ClusterService;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.Force2FAService;
import com.alphaserve.twofactor.core.services.PluginInfoService;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.services.entities.FailLogin2FAService;
import com.alphaserve.twofactor.core.services.entities.RememberMeService;
import com.alphaserve.twofactor.core.services.entities.SecretKeyService;
import com.alphaserve.twofactor.core.utils.UrlUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class AuthLoginServiceImpl
implements AuthLoginService {
    private static final String AUTH_PREFIX = "auth";
    private static final String AUTH_HTTP_HEADER_REFERER = "referer";
    public static final String MOBILE_LOGIN = "alpha-auth-mobile-login";
    private final Auth2FAService auth2FAService;
    @ComponentImport
    private final UserManager userManager;
    private final UserService userService;
    private final PluginInfoService pluginInfoService;
    private final AuthFilterManager authFilterManager;
    private final ConfigurationService configurationService;
    private final FailLogin2FAService failLogin2FAService;
    private final Force2FAService force2FAService;
    private final SecretKeyService secretKeyService;
    private final ClusterService clusterService;
    private final RememberMeService rememberMeService;

    @Inject
    public AuthLoginServiceImpl(Auth2FAService auth2FAService, @Qualifier(value="userManager") UserManager userManager, UserService userService, PluginInfoService pluginInfoService, ConfigurationService configurationService, FailLogin2FAService failLogin2FAService, Force2FAService force2FAService, SecretKeyService secretKeyService, ClusterService clusterService, RememberMeService rememberMeService, AuthFilterManager authFilterManager) {
        this.auth2FAService = auth2FAService;
        this.userManager = userManager;
        this.userService = userService;
        this.pluginInfoService = pluginInfoService;
        this.configurationService = configurationService;
        this.failLogin2FAService = failLogin2FAService;
        this.force2FAService = force2FAService;
        this.secretKeyService = secretKeyService;
        this.authFilterManager = authFilterManager;
        this.clusterService = clusterService;
        this.rememberMeService = rememberMeService;
    }

    @Override
    public void login2fa(HttpSession httpSession) {
        UserProfile userProfile = this.userManager.getRemoteUser();
        this.login2fa(httpSession, userProfile);
    }

    @Override
    public void login2fa(HttpSession httpSession, UserProfile userProfile) {
        if (Objects.isNull(userProfile)) {
            return;
        }
        httpSession.setAttribute(AUTH_PREFIX + userProfile.getUserKey().getStringValue(), (Object)Boolean.toString(true));
    }

    @Override
    public void logout2fa(HttpSession httpSession) {
        UserProfile userProfile = this.userManager.getRemoteUser();
        if (Objects.isNull(userProfile)) {
            return;
        }
        if (this.clusterService.isClustered()) {
            this.rememberMeService.deleteRememberedUserClusterByUserKey(httpSession, userProfile.getUserKey().getStringValue());
        }
        httpSession.removeAttribute(AUTH_PREFIX + userProfile.getUserKey().getStringValue());
        httpSession.removeAttribute("ip_filter" + userProfile.getUserKey().getStringValue());
        httpSession.removeAttribute("remember-" + DigestUtils.md5Hex(userProfile.getUserKey().getStringValue()));
        httpSession.removeAttribute(MOBILE_LOGIN);
    }

    @Override
    public boolean isLogged2fa(HttpSession httpSession) {
        return this.isValueFromSession(httpSession, AUTH_PREFIX);
    }

    @Override
    public boolean isLogged2fa(HttpSession httpSession, UserProfile userProfile) {
        return this.isValueFromSession(httpSession, AUTH_PREFIX, userProfile);
    }

    @Override
    public boolean isLoggedByIp(HttpSession httpSession) {
        return this.isValueFromSession(httpSession, "ip_filter");
    }

    private boolean isValueFromSession(HttpSession httpSession, String authIpFilter) {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.isValueFromSession(httpSession, authIpFilter, userProfile);
    }

    private boolean isValueFromSession(HttpSession httpSession, String authIpFilter, UserProfile userProfile) {
        if (Objects.isNull(userProfile)) {
            return false;
        }
        String attribute = (String)httpSession.getAttribute(authIpFilter + userProfile.getUserKey().getStringValue());
        return Objects.nonNull(attribute) && Boolean.parseBoolean(attribute);
    }

    @Override
    public boolean isPermitted(HttpSession httpSession) {
        UserProfile userProfile = this.userService.getUserProfile();
        if (this.pluginInfoService.isSystemAdmin()) {
            return true;
        }
        if (Objects.isNull(userProfile)) {
            return false;
        }
        return !this.auth2FAService.isUserHasEnabled2fa(userProfile) || this.isLogged2fa(httpSession) || this.isLoggedByIp(httpSession);
    }

    @Override
    public boolean isLogged(HttpSession httpSession) {
        UserProfile userProfile = this.userService.getUserProfile();
        if (Objects.isNull(userProfile)) {
            return false;
        }
        Auth2FACacheWrapper auth2FA = this.auth2FAService.getWrappedEntityByUserKey(userProfile.getUserKey());
        return this.isLogged(httpSession, auth2FA);
    }

    @Override
    public boolean isLogged(HttpSession httpSession, Auth2FACacheWrapper auth2FA) {
        return auth2FA.isActive() && (this.isLogged2fa(httpSession) || this.isLoggedByIp(httpSession));
    }

    @Override
    public boolean isUserHave2fa() {
        UserProfile userProfile = this.userService.getUserProfile();
        if (Objects.isNull(userProfile)) {
            return false;
        }
        Auth2FACacheWrapper auth2FA = this.auth2FAService.getWrappedEntityByUserKey(userProfile.getUserKey());
        return auth2FA.isActive();
    }

    @Override
    public boolean isUserHave2fa(String username) {
        UserProfile userProfile = this.userService.getUserProfile(username);
        if (Objects.isNull(userProfile)) {
            return false;
        }
        Auth2FACacheWrapper auth2FA = this.auth2FAService.getWrappedEntityByUserKey(userProfile.getUserKey());
        return auth2FA.isActive();
    }

    @Override
    public boolean isAllowedMobile(HttpServletRequest req, String username, boolean isReadOnlyMode) throws LockedException, ForceException {
        if (!this.pluginInfoService.isPluginLicensed()) {
            return true;
        }
        UserProfile userProfile = this.userService.getUserProfile(username);
        if (Objects.nonNull(userProfile) && Objects.nonNull(userProfile.getUserKey())) {
            FilterState authResult = this.authFilterManager.getAuthMobileResult(this.auth2FAService, req, this.configurationService, this.userManager, this.failLogin2FAService, this.force2FAService, userProfile.getUserKey(), UrlUtils.getRequestPath(req.getRequestURI()));
            switch (authResult) {
                case LOGGED_IN: 
                case PASS: {
                    return true;
                }
                case FORCE: {
                    throw new ForceException();
                }
                case LOCKED: {
                    throw new LockedException();
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isUserMustSeeCodes() {
        UserProfile userProfile = this.userService.getUserProfile();
        return Objects.nonNull(userProfile) && this.secretKeyService.isUserMustSeeCodes(userProfile);
    }

    @Override
    public boolean isServiceDeskFromAjax(HttpServletRequest req) {
        return !(!Objects.nonNull(this.userManager.getRemoteUser()) || this.isLogged(req.getSession()) && !this.isUserMustSeeCodes() || !req.getRequestURI().contains("/servicedesk/customer/portal") || !Objects.nonNull(req.getHeader("X-Requested-With")) || !req.getHeader(AUTH_HTTP_HEADER_REFERER).contains("/plugins/servlet/authplugin/authlogin") && !req.getHeader(AUTH_HTTP_HEADER_REFERER).contains("/plugins/servlet/authplugin/tfaconfiguration") && !req.getHeader(AUTH_HTTP_HEADER_REFERER).contains("/plugins/servlet/authplugin/locked"));
    }
}

