/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.export;

import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionFilterDTO;
import com.alphaserve.twofactor.core.services.export.impl.CsvExportService;
import com.alphaserve.twofactor.core.services.export.impl.XlsExportService;
import com.alphaserve.twofactor.core.services.export.impl.XlsxExportService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ExportService {
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @ComponentImport
    private I18nResolver i18nResolver;
    private CsvExportService csvExportService;
    private XlsExportService xlsExportService;
    private XlsxExportService xlsxExportService;

    @Inject
    public ExportService(I18nResolver i18nResolver, CsvExportService csvExportService, XlsExportService xlsExportService, XlsxExportService xlsxExportService) {
        this.i18nResolver = i18nResolver;
        this.csvExportService = csvExportService;
        this.xlsExportService = xlsExportService;
        this.xlsxExportService = xlsxExportService;
    }

    public ByteArrayOutputStream export(List<LogActionDTO> logs, String type) {
        switch (type) {
            default: {
                return this.csvExportService.getLogs(logs);
            }
            case "XLS": {
                if (logs.size() > XlsExportService.MAX_ROWS) {
                    return this.xlsExportService.generateZip(logs);
                }
                return this.xlsExportService.getLogs(logs);
            }
            case "XLSX": 
        }
        return this.xlsxExportService.getLogs(logs);
    }

    public String generateFileName(LogActionFilterDTO filterDTO, int size, String type) {
        String extension = type.equals("XLS") && size > XlsExportService.MAX_ROWS ? "zip" : type.toLowerCase();
        String dateFrom = Objects.nonNull(filterDTO.getStartDate()) ? this.simpleDateFormat.format(filterDTO.getStartDate()) : this.simpleDateFormat.format(new Date());
        String dateTo = Objects.nonNull(filterDTO.getFinishDate()) ? "--" + this.simpleDateFormat.format(filterDTO.getFinishDate()) : "";
        return this.i18nResolver.getText("auth.export.logger.filename") + "-" + dateFrom + dateTo + "." + extension;
    }
}

