/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.export;

import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionDTO;
import com.alphaserve.twofactor.core.services.export.ExportHeaders;
import com.alphaserve.twofactor.core.services.export.OwnTimeZoneManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.LocaleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelExportService {
    protected final Logger logger = LoggerFactory.getLogger(ExcelExportService.class);
    protected static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    @ComponentImport
    protected I18nResolver i18nResolver;
    protected OwnTimeZoneManager timeZoneManager;

    protected ExcelExportService(I18nResolver i18nResolver, OwnTimeZoneManager timeZoneManager) {
        this.i18nResolver = i18nResolver;
        this.timeZoneManager = timeZoneManager;
    }

    public abstract ByteArrayOutputStream getLogs(List<LogActionDTO> var1);

    protected ByteArrayOutputStream generate(Workbook workbook, Sheet sheet, List<LogActionDTO> logs) {
        LocaleUtil.setUserTimeZone(this.timeZoneManager.getUserTimeZone());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.generateHeader(sheet, workbook);
        this.createTableRows(sheet, workbook, logs);
        this.autoSizeColumns(sheet);
        try {
            workbook.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        return byteArrayOutputStream;
    }

    private void autoSizeColumns(Sheet sheet) {
        ExportHeaders[] headers = ExportHeaders.values();
        for (int i = 0; i < headers.length; ++i) {
            sheet.autoSizeColumn(i);
        }
    }

    private void generateHeader(Sheet sheet, Workbook workbook) {
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        CellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFont(headerFont);
        Row headerRow = sheet.createRow(0);
        int t2 = 0;
        for (ExportHeaders header : ExportHeaders.values()) {
            Cell cell = headerRow.createCell(t2++);
            cell.setCellStyle(headerCellStyle);
            cell.setCellValue(this.i18nResolver.getText(header.getCode()));
        }
    }

    private void createTableRows(Sheet sheet, Workbook workbook, List<LogActionDTO> logs) {
        CellStyle cellStyle = workbook.createCellStyle();
        CreationHelper createHelper = workbook.getCreationHelper();
        cellStyle.setDataFormat(createHelper.createDataFormat().getFormat(DATE_FORMAT));
        int t2 = 0;
        for (int i = 0; i < logs.size(); ++i) {
            LogActionDTO log = logs.get(i);
            Row cellRow = sheet.createRow(i + 1);
            cellRow.createCell(t2++).setCellValue(log.getUsername());
            Cell cell = cellRow.createCell(t2++);
            cell.setCellValue(log.getDate());
            cell.setCellStyle(cellStyle);
            cellRow.createCell(t2++).setCellValue(log.getAction());
            cellRow.createCell(t2).setCellValue(log.getUserIp());
            t2 = 0;
        }
    }
}

