/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.Plugin2FACoreContext;
import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.model.entities.SecretKey;
import com.alphaserve.twofactor.core.model.entities.cache.wraper.Auth2FACacheWrapper;
import com.alphaserve.twofactor.core.model.exceptions.NoReserveCodesException;
import com.alphaserve.twofactor.core.security.Totp;
import com.alphaserve.twofactor.core.services.database.TwoFADatabaseToolkit;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.services.entities.SecretKeyService;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Named
public class SecretKeyServiceImpl
implements SecretKeyService {
    private static final int RESERVE_KEY_LENGTH = 16;
    private static final int SECRET_KEYS_PER_2FA = 10;
    private static final int ARBITARY_SIZE = 1024;
    public static final String CODES_PREFIX = "download-codes-";
    private final Auth2FAService auth2FAService;
    private final TwoFADatabaseToolkit dbToolkit;
    private final Plugin2FACoreContext pluginContext;

    @Inject
    public SecretKeyServiceImpl(Auth2FAService auth2FAService, TwoFADatabaseToolkit dbToolkit, Plugin2FACoreContext pluginContext) {
        this.auth2FAService = auth2FAService;
        this.pluginContext = pluginContext;
        this.dbToolkit = dbToolkit;
    }

    @Override
    public SecretKey add(int authId, String key) {
        return this.dbToolkit.useActiveObjects(ao -> (SecretKey)ao.executeInTransaction(() -> {
            SecretKey secretKey = (SecretKey)ao.create(SecretKey.class, new DBParam[0]);
            secretKey.setAuthId(authId);
            secretKey.setKey(key);
            secretKey.save();
            return secretKey;
        }), (Supplier)this.dbToolkit.returnNull());
    }

    @Override
    public List<SecretKey> generateUserSecretKeys(Auth2FA auth2FA, Totp totp) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<SecretKey> secretKeys = new ArrayList<SecretKey>();
        for (int i = 0; i < 10; ++i) {
            keys.add(totp.generateBase32Secret(16));
        }
        for (String key : keys) {
            secretKeys.add(this.dbToolkit.useActiveObjects(ao -> (SecretKey)ao.executeInTransaction(() -> {
                SecretKey secretKey = (SecretKey)ao.create(SecretKey.class, new DBParam[0]);
                secretKey.setAuthId(auth2FA.getID());
                secretKey.setKey(key);
                secretKey.save();
                return secretKey;
            }), (Supplier)this.dbToolkit.returnNull()));
        }
        return secretKeys;
    }

    @Override
    public List<SecretKey> getByAuth(Auth2FA auth2FA) {
        if (Objects.isNull(auth2FA)) {
            return new ArrayList<SecretKey>();
        }
        Query query = Query.select().where("AUTHID = ?", new Object[]{auth2FA.getID()}).limit(10);
        SecretKey[] reserveKeys = this.dbToolkit.useActiveObjects(ao -> (SecretKey[])ao.executeInTransaction(() -> (SecretKey[])ao.find(SecretKey.class, query)), (Supplier)this.dbToolkit.returnNull());
        if (Objects.isNull(reserveKeys)) {
            return new ArrayList<SecretKey>();
        }
        return Lists.newArrayList(reserveKeys);
    }

    @Override
    public List<SecretKey> getByUser(UserProfile userProfile) {
        Auth2FA auth2FA = this.auth2FAService.getByUserKey(userProfile.getUserKey());
        return this.getByAuth(auth2FA);
    }

    @Override
    public void delete(SecretKey secretKey) {
        this.dbToolkit.useActiveObjects(ao -> ao.delete(new RawEntity[]{secretKey}));
    }

    @Override
    public void deleteList(List<SecretKey> secretKey) {
        for (SecretKey aSecretKey : secretKey) {
            this.delete(aSecretKey);
        }
    }

    @Override
    public boolean reserveSecretPass(Auth2FA auth2FA, String key, boolean isReadOnlyMode) {
        boolean reserveSecretPass = false;
        List<SecretKey> reserveSecretKeys = this.getByAuth(auth2FA);
        if (Objects.nonNull(reserveSecretKeys)) {
            for (SecretKey reserveSecretKey : reserveSecretKeys) {
                if (!reserveSecretKey.getKey().equals(key)) continue;
                if (!isReadOnlyMode) {
                    this.delete(reserveSecretKey);
                }
                reserveSecretPass = true;
                break;
            }
        }
        return reserveSecretPass;
    }

    @Override
    public SecretKey getByKey(long authId, String key) {
        SecretKey[] secretKeys = this.dbToolkit.useActiveObjects(ao -> (SecretKey[])ao.executeInTransaction(() -> (SecretKey[])ao.find(SecretKey.class, Query.select().where("KEY = ? AND AUTHID = ?", new Object[]{key, authId}).limit(1))), this.dbToolkit::returnNull);
        if (Objects.isNull(secretKeys) || secretKeys.length == 0) {
            return null;
        }
        return secretKeys[0];
    }

    @Override
    public boolean isUserMustSeeCodes(UserProfile userProfile) {
        Auth2FACacheWrapper auth2FA = this.auth2FAService.getWrappedEntityByUserKey(userProfile);
        return Objects.nonNull(auth2FA) && !auth2FA.isConfirmed() && auth2FA.isActive();
    }

    @Override
    public void downloadCodes(Auth2FA auth2FA, HttpServletResponse response) throws NoReserveCodesException, IOException {
        StringBuilder keys = new StringBuilder();
        List<SecretKey> secretKeys = this.getByAuth(auth2FA);
        if (Objects.isNull(secretKeys) || secretKeys.isEmpty()) {
            throw new NoReserveCodesException();
        }
        for (SecretKey secretKey : secretKeys) {
            keys.append(secretKey.getKey()).append(System.lineSeparator());
        }
        response.setHeader("Content-Disposition", "attachment; filename=" + this.pluginContext.getBackupFileName());
        try (ServletOutputStream out = response.getOutputStream();){
            int numBytesRead;
            ByteArrayInputStream in = new ByteArrayInputStream(keys.toString().getBytes());
            byte[] buffer = new byte[1024];
            while ((numBytesRead = in.read(buffer)) > 0) {
                out.write(buffer, 0, numBytesRead);
            }
            ((InputStream)in).close();
            out.flush();
        }
    }

    @Override
    public void deleteAll() {
        this.dbToolkit.useActiveObjects(ao -> ao.deleteWithSQL(SecretKey.class, "ID > ?", new Object[]{0}));
    }

    @Override
    public void deleteBy(Auth2FA auth2FA) {
        if (Objects.isNull(auth2FA)) {
            return;
        }
        this.dbToolkit.useActiveObjects(ao -> ao.deleteWithSQL(SecretKey.class, "AUTHID = ?", new Object[]{auth2FA.getID()}));
    }

    @Override
    public boolean isAllowedToDownload(HttpServletRequest request, Auth2FA auth2FA) {
        if (Objects.isNull(auth2FA) || !auth2FA.getActive()) {
            return false;
        }
        Long attribute = (Long)request.getSession().getAttribute(CODES_PREFIX + auth2FA.getUserKey());
        return Objects.nonNull(attribute) && (System.currentTimeMillis() - attribute) / 1000L < 300L;
    }
}

