/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.cache;

import com.alphaserve.twofactor.core.services.cache.CacheManagerI;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public abstract class GenericClusterCacheManager<T>
implements CacheManagerI<T> {
    private final Cache<Integer, T> cache;

    protected GenericClusterCacheManager(CacheManager cacheManager) {
        this.cache = cacheManager.getCache(this.getClassName() + ".cache", null, new CacheSettingsBuilder().expireAfterWrite(this.expireAfterWriteMinutes(), TimeUnit.MINUTES).replicateSynchronously().build());
        this.deleteAll();
    }

    @Override
    public void deleteByKey(Object key) {
        this.cache.remove((Object)key.hashCode());
    }

    @Override
    public Optional<T> getByKey(Object key) {
        return Objects.nonNull(key) ? Optional.ofNullable(this.cache.get((Object)key.hashCode())) : Optional.empty();
    }

    @Override
    public void cacheEntity(Object key, T entity) {
        this.cache.put((Object)key.hashCode(), entity);
    }

    @Override
    public void deleteAll() {
        this.cache.removeAll();
    }

    protected abstract long expireAfterWriteMinutes();

    protected abstract String getClassName();
}

