define('auth/elements', function () {
    function getLoginButton() {
        return '<input class="tfa-login-button aui-button aui-button-primary" id="tfa-login-button" ' +
            'type="button" value="' + AJS.I18n.getText("auth.text.login") + '" ' +
            'onclick="return false" type="submit"/>'
    }

    function getCodeInput() {
        return '<input autocomplete="off" type="text" id="tfa-login-key" class="text" name="tfa-login-key" ' +
            'placeholder="' + AJS.I18n.getText("auth.text.enter_key_description") + '" autofocus="autofocus">'
    }

    function getHiddenUsername(username) {
        return '<input name="alpha_auth_username" type="hidden" value="' + username + '"> ';
    }

    return {
        getLoginButton: getLoginButton,
        getCodeInput: getCodeInput,
        getHiddenUsername: getHiddenUsername,
    }
});

require(['auth/elements', 'jquery', 'wrm/context-path'],
    function (elements, $, contextPath) {
        $(document).ready(function () {
            if (navigator.userAgent.includes("AtlassianMobileApp")) {
                var passwordFieldId = "#login-form-password, #os_password, #j_password, #loginForm_os_password";
                var loginButtonId = "input#login, #login-form-submit, #loginButton, #submit, input#loginForm_save";
                var usernameFieldId = "#login-form-username, #os_username, #j_username, #loginForm_os_username";
                var formBody = '.form-body, #action-messages';
                var tfaLoginKey = "#tfa-login-key"

                var tfaLoginButtonId = "#tfa-login-button";

                if ($('#dashboard').length) {
                    waitLoading();
                    $(document).ajaxComplete(function (event, xhr, settings) {
                        if (settings.url === contextPath() + '/rest/gadget/1.0/login') {
                            waitLoading();
                        }
                    })
                } else {
                    changeForm();
                }

                function waitLoading() {
                    var retries = 100;

                    var timeoutFunction = function () {
                        if (!changeForm() && retries >= 0) {
                            retries -= 1;
                            setTimeout(timeoutFunction, 100);
                        }
                    };

                    setTimeout(timeoutFunction, 50);
                }

                function changeForm() {
                    var passwordField = $(passwordFieldId).closest('div');
                    var loginButton = $(loginButtonId);

                    if (!passwordField.length || !loginButton.length) {
                        return false;
                    }

                    loginButton.before(elements.getLoginButton());
                    loginButton.hide();

                    var tfaButton = $(tfaLoginButtonId);
                    tfaButton.unbind("click");
                    tfaButton.bind("click", function () {
                        $.ajax({
                            url: contextPath() + '/rest/authpluginresources/1.0/totp_resources/is_allowed',
                            type: "POST",
                            data: JSON.stringify({
                                    username: $(usernameFieldId).val(),
                                    userAgent: navigator.userAgent
                                }
                            ),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function () {
                                initTfaLogin();
                            },
                            error: function (xhr) {
                                if (xhr.responseText !== "") {
                                    performErrors(xhr.responseText);
                                } else {
                                    useBasicLogin()
                                }
                            }
                        });
                    });

                    return true;
                }

                function performErrors(error) {
                    $('.aui-message.aui-message-error').remove();
                    $(loginButtonId).hide();
                    $(usernameFieldId).hide();
                    $(passwordFieldId).hide();
                    $(formBody).prepend(error)
                    if (!error.includes("data-wrongCode=\"true\"")) {
                        $(tfaLoginKey).hide();
                        $(tfaLoginButtonId).hide();
                    }
                }

                function useBasicLogin() {
                    $(loginButtonId).click();
                }

                function initTfaLogin() {
                    $(loginButtonId).hide();
                    $(usernameFieldId).hide();
                    $(passwordFieldId).hide();
                    $(usernameFieldId).before(elements.getCodeInput())
                    $(usernameFieldId).before(elements.getHiddenUsername($(usernameFieldId).val()))
                    var tfaButton = $(tfaLoginButtonId);
                    tfaButton.unbind("click");
                    tfaButton.bind("click", function () {
                        checkTotpCode()
                    });
                }

                function checkTotpCode() {
                    $.ajax({
                        url: contextPath() + "/rest/authpluginresources/1.0/totp_resources/validate",
                        type: "POST",
                        data: JSON.stringify({
                            code: $("#tfa-login-key").val(),
                            username: $(usernameFieldId).val()
                        }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "text",
                        cache: false,
                        success: function () {
                            useBasicLogin();
                        },
                        error: function (xhr) {
                            performErrors(xhr.responseText);
                            $(tfaLoginKey).val("");
                        }
                    });
                }
            }
        });
    });
