const ERROR_MESSAGE_DELAY = 5 * 1000;

AJS.$(window).load(function () {

    let dialogErrorBannerContext = null;
    const dialogErrorBanner = AJS.$("#dialog-error-banner");
    const dialogErrorBannerMsg = AJS.$("#dialog-error-banner-msg");
    const dateSelectContainer = AJS.$("#selected-date-container");
    const authLoggerTableBody = AJS.$("#auth-logger-table tbody");
    const authLoggerPaginationPanel = AJS.$(".authentication-logger-pagination-panel");

    const filterUsernameInput = AJS.$("#log-username");
    const filterStartReportDateInput = AJS.$("#start-report-date");
    const filterFinishReportDateInput = AJS.$("#finish-report-date");
    const filterUserIPInput = AJS.$("#log-userip");
    const filterActionTypeSelect = AJS.$("#filter-action-select");

    const authLoggerFilterButton = AJS.$(".authentication-logs-filter-button");
    const selectDateDialogCloseButton = AJS.$("#select-date-dialog-close-button");
    const selectDateDialogButton = AJS.$("#date-select-button");
    const clearLoggerFilters = AJS.$(".clear-logger-filters-button");

    const atlToken = AJS.$("input:hidden[name=atl_token]");

    filterActionTypeSelect.auiSelect2();
    dialogErrorBanner.hide();
    initExport();
    loadPage(1);

    updateDateSelectContainerDate();

    clearLoggerFilters.unbind("click");
    clearLoggerFilters.bind("click", function () {
        filterUsernameInput.val("");
        filterUserIPInput.val("");
        filterStartReportDateInput.val(null);
        filterFinishReportDateInput.val(null);
        filterActionTypeSelect.val('All');
        filterActionTypeSelect.trigger('change');
        dateSelectContainer.html(" - ");
        loadPage(1);
    });

    selectDateDialogButton.unbind("click");
    selectDateDialogButton.bind("click", function () {
        AJS.dialog2("#select-date-dialog").show();
    });

    selectDateDialogCloseButton.unbind("click");
    selectDateDialogCloseButton.bind("click", function () {
        AJS.dialog2("#select-date-dialog").hide();
    });

    filterStartReportDateInput.unbind("change");
    filterStartReportDateInput.bind("change", function () {
        const contextElement = AJS.$(this);
        clearTimeout(dialogErrorBannerContext);
        closeDialogErrorMsg();
        handleDateInputsValues(contextElement, filterFinishReportDateInput, contextElement);
    });

    filterFinishReportDateInput.unbind("change");
    filterFinishReportDateInput.bind("change", function () {
        const contextElement = AJS.$(this);
        clearTimeout(dialogErrorBannerContext);
        closeDialogErrorMsg();
        handleDateInputsValues(filterStartReportDateInput, contextElement, contextElement);
    });

    authLoggerFilterButton.unbind("click");
    authLoggerFilterButton.bind("click", function () {
        loadPage(1);
    });

    function dateToString(date) {
        return date ? `${("000" + date.getFullYear()).slice(-4)}-${("0" + (date.getMonth() + 1)).slice(-2)}-${("0" + date.getDate()).slice(-2)}` : '';
    }

    function getValidDateForFinishDate(startDate) {
        const finishDateValue = new Date(startDate.val());
        finishDateValue.setDate(finishDateValue.getDate() + 1);
        return finishDateValue;
    }

    function getValidDateForStartDate(finishDate) {
        const startDateValue = new Date(finishDate.val());
        startDateValue.setDate(startDateValue.getDate() - 1);
        return startDateValue;
    }

    function validateDateValue(value) {
        return value.length <= 10
    }

    function handleDateInputsValues(startDate, finishDate, contextElement) {
        if (validateDateValue(contextElement.val())) {
            const startDateStrValue = startDate.val();
            const finishDateStrValue = finishDate.val();
            let startDateValue = new Date(startDateStrValue);
            let finishDateValue = new Date(finishDateStrValue);

            if (startDateStrValue && finishDateStrValue && startDateValue > finishDateValue) {
                if (contextElement === finishDate) {
                    startDateValue = getValidDateForStartDate(finishDate);
                    startDate.val(dateToString(startDateValue));
                    
                } else {
                    finishDateValue = getValidDateForFinishDate(startDate);
                    finishDate.val(dateToString(finishDateValue));
                }
            }
        } else {
            showDialogErrorMsg(AJS.I18n.getText("auth.text.incorrect-date"), ERROR_MESSAGE_DELAY);
            const validDate = contextElement === finishDate && validateDateValue(startDate.val())
                ? getValidDateForFinishDate(startDate) : validateDateValue(finishDate.val())
                    ? getValidDateForStartDate(finishDate) : null;
            contextElement.val(dateToString(validDate));
        }

        updateDateSelectContainerDate();
    }

    function closeDialogErrorMsg() {
        dialogErrorBanner.hide();
        dialogErrorBannerContext = null;
    }

    function showDialogErrorMsg(dictionaryKey, delay) {
        if (dialogErrorBannerContext) {
            clearTimeout(dialogErrorBannerContext);
            dialogErrorBannerContext = null;
        }

        dialogErrorBannerMsg.text(dictionaryKey);
        dialogErrorBanner.show();

        dialogErrorBannerContext = setTimeout(closeDialogErrorMsg, delay);
    }

    function updateDateSelectContainerDate() {
        dateSelectContainer.html(filterStartReportDateInput.val() + " - " + filterFinishReportDateInput.val());
    }

    function loadPage(page) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/authlogger/" + page + "?atl_token=" + atlToken.val(),
            dataType: "json",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify({
                username: filterUsernameInput.val(),
                startDate: filterStartReportDateInput.val(),
                finishDate: filterFinishReportDateInput.val(),
                action: filterActionTypeSelect.val(),
                userIp: filterUserIPInput.val(),
                page: page
            }),
            type: "POST",
            cache: false,
            success: function (data) {
                authLoggerPaginationPanel.html(pagination(page, data.pageCount, gotoPage));

                authLoggerTableBody.empty();

                appendAuthLoggerEntities(authLoggerTableBody, data.entities);
            },
            error: function () {
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
            }
        });
    }

    function gotoPage(event) {
        loadPage(event.data.pageNum);
    }

    function renderPrevious(currentPage, action) {
        if (currentPage > 1) {
            var link = AJS.$("<a href='#'>" + AJS.I18n.getText("auth.text.prev") + "</a>");
            link.on("click", { pageNum: currentPage - 1 }, action);
            return AJS.$("<li></li>").addClass("aui-nav-previous").append(link);
        } else {
            return null;
        }
    }

    function renderNext(currentPage, lastPage, action) {
        if (currentPage < lastPage) {
            var link = AJS.$("<a href='#'>" + AJS.I18n.getText("auth.text.next") + "</a>");
            link.on("click", { pageNum: currentPage + 1 }, action);
            return AJS.$("<li></li>").addClass("aui-nav-previous").append(link);
        } else {
            return null;
        }
    }

    function renderPageEntry(index, currentPage, action) {
        if (index === currentPage) {
            return "<li class='aui-nav-selected'>" + index + "</li>";
        } else {
            var link = AJS.$("<a href='#'>" + index + "</a>");
            link.on("click", { pageNum: index }, action);
            return AJS.$("<li></li>").append(link);
        }
    }

    function renderTruncation() {
        var link = AJS.$("<a href='#'>&hellip;</a>");
        return AJS.$("<li></li>").addClass("aui-nav-truncation").append(link);
    }

    function pagination(currentPage, lastPage, action) {
        var paginator = AJS.$("<ol></ol>").addClass("aui-nav").addClass("aui-nav-pagination");

        paginator.append(renderPrevious(currentPage, action));

        var left = Math.max(currentPage - 2, 1);
        var right = Math.min(currentPage + 2, lastPage);

        if (left > 1) {
            paginator.append(renderTruncation());
        }

        for (var i = left; i < right + 1; i++) {
            paginator.append(renderPageEntry(i, currentPage, action));
        }

        if (right < lastPage) {
            paginator.append(renderTruncation());
        }

        paginator.append(renderNext(currentPage, lastPage, action));

        return paginator;
    }

    function appendAuthLoggerEntities(tableBody, entities) {
        AJS.$(entities).each(function (d, e) {
            tableBody.append("<tr>" +
                "    <td>" + e.username + "</td>" +
                "    <td>" + e.date + "</td>" +
                "    <td>" + e.action + "</td>" +
                "    <td>" + e.userIp + "</td>" +
                "    <td></td>" +
                "</tr>")
        });
    }

    function initExport() {
        var exportButtons = AJS.$(".export-logs-link");

        exportButtons.unbind();
        exportButtons.on('click', function () {
            window.open(AJS.contextPath() + "/rest/authpluginresources/1.0/authlogger/export?" + getExportParams(AJS.$(this).attr("data-type")), "_blank");
        });
    }

    function getExportParams(type) {
        return "username=" + filterUsernameInput.val()
            + "&startDate=" + filterStartReportDateInput.val()
            + "&finishDate=" + filterFinishReportDateInput.val()
            + "&action=" + filterActionTypeSelect.val()
            + "&userIp=" + filterUserIPInput.val()
            + "&type=" + type;
    }
});


