function configuringDeviceLogin(env) {
    var u2fDeviceMessageContainer = AJS.$(".u2f-device-message-container");

    var rememberMeEnableCheckbox = AJS.$("#remember-me-user-enable");

    var rememberMeConfirmButton = AJS.$("#confirm-use-remember-me");

    var atlToken = AJS.$("input:hidden[name=atl_token]");

    rememberMeConfirmButton.hide();

    var loginWaysLinks = AJS.$(".tfa-enter-way-link");

    loginWaysLinks.bind("url-changed", function () {
        rememberMeConfirmButton.hide();
        init();
    });
    init();

    function init() {
        if (getAlphaServe2FAEnterWay() === "u2f-login-way" && AJS.$("#no-valid-license").length === 0) {
            if (rememberMeConfirmButton.length > 0 && webAuthnBrowserCompatibility()) {
                rememberMeConfirmButton.show();
                rememberMeConfirmButton.unbind("click");
                rememberMeConfirmButton.bind("click", function () {
                    initU2fLogin();
                });
            } else {
                if (webAuthnBrowserCompatibility()) {
                    initU2fLogin();
                }
            }
        }
    }

    function initU2fLogin() {
        AJS.$.ajax({
            url: AJS.contextPath() + '/rest/authpluginresources/1.0/webauth_resources/init_assertion?atl_token='+atlToken.val(),
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (data) {
                initLogin(data.publicKeyCredentialRequestOptions);
            },
            error: function (data) {
                if (data.status === 200 && data.readyState === 4) {//redirect
                    location.href = getAlphaServeLockedUrl();
                } else {
                    //IF UNKNOWN ERROR OCCURRED USER MUST USE TOTP
                    parseUserErrors(data);
                }
            }
        });
    }

    function initLogin(data) {
        if (webAuthnBrowserCompatibility()) {
            navigator.credentials.get({
                publicKey: preparePublicKeyCredentialRequestOptions(data),
            }).then(function (credential) {
                finishLogin(credential);
            }, function (error) {
                if (!(error.name === 'NotAllowedError' || error.name === 'AbortError')) {
                    if (error.message) {
                        alphaServe2FAErrorMessageFlag(error.message);
                    }
                }
            })
        } else {
            u2fDeviceMessageContainer.text(AJS.I18n.getText("auth.text.settings-u2f-browser-not-support-u2f"));
        }
    }

    function preparePublicKeyCredentialRequestOptions(request) {
        request.challenge = stringToByteArray(request.challenge);
        request.allowCredentials.forEach(function (item) {
            item.id = stringToByteArray(item.id)
        });

        return request;
    }

    function finishLogin(assertedCredential) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/webauth_resources/finish_login?atl_token="+atlToken.val(),
            type: "POST",
            data: JSON.stringify({
                tokenResponse: JSON.stringify(preparePublicKeyCredential(assertedCredential)),
                rememberMe: rememberMeEnableCheckbox.attr('checked') !== undefined
            }),
            contentType: "application/json; charset=utf-8",
            dataType: "text",
            cache: false,
            success: function (data) {
                redirectOrCloseDialog(env.inDialogWindow)
            },
            error: function (data) {
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
            }
        });
    }

    function preparePublicKeyCredential(assertedCredential) {
        var data = {};
        data.response = {};
        data.id = assertedCredential.id;
        data.type = assertedCredential.type;

        data.response.authenticatorData = arrayBufferToString(assertedCredential.response.authenticatorData);
        data.response.clientDataJSON = arrayBufferToString(assertedCredential.response.clientDataJSON);
        data.response.signature = arrayBufferToString(assertedCredential.response.signature);
        var userHandle = arrayBufferToString(assertedCredential.response.userHandle);
        if (userHandle) {
            data.response.userHandle = userHandle
        }
        try {
            data.clientExtensionResults = assertedCredential.getClientExtensionResults();
        } catch (e) {
            console.error('getClientExtensionResults failed', e);//TODO
        }
        return data;
    }

    function getBaseUrl() {
        if (typeof Confluence !== 'undefined') {
            return Confluence.getBaseUrl();
        }
        if (typeof AJS.params.baseURL !== 'undefined') {
            return AJS.params.baseURL;
        }
        var ajsBaseUrl = $("meta[name='ajs-base-url']");
        if (ajsBaseUrl.length > 0) {
            return ajsBaseUrl.attr("content");
        }

        return window.location.origin + AJS.contextPath();
    }
}

AJS.$(document).ready(configuringDeviceLogin);
