AJS.$(document).ready(function () {

    window.onbeforeunload = null;

    var u2fDeviceAddFlowContainer = AJS.$(".u2f-device-add-flow-container");
    var u2fDeviceAddInitContainer = AJS.$(".u2f-device-add-init-container");
    var u2fDeviceAddNameContainer = AJS.$(".u2f-device-add-name-container");
    var u2fDeviceAddActionContainer = AJS.$(".u2f-device-add-action-container");

    var u2fAddDeviceButton = AJS.$(".u2f-device-control-add-button");
    var u2fAddDeviceSubmitNameButton = AJS.$(".u2f-device-control-add-name-button");

    var u2fAddDeviceNameInput = AJS.$("#u2f-add-device-name-input");
    var atlToken = AJS.$("input:hidden[name=atl_token]");

    u2fAddDeviceSubmitNameButton.unbind("click");
    u2fAddDeviceSubmitNameButton.bind("click", function () {
        submitU2FAddNameDevice();
    });

    u2fAddDeviceButton.unbind("click");
    u2fAddDeviceButton.bind("click", function () {
        initU2FRegisterDevice();
    });

    function initU2FRegisterDevice() {
        u2fDeviceAddFlowContainer.hide();
        u2fDeviceAddNameContainer.show();
    }

    function submitU2FAddNameDevice() {
        u2fDeviceAddFlowContainer.hide();
        u2fDeviceAddActionContainer.show();
        initU2fRegister();
    }

    function returnU2FStartPositionAddDevice() {
        u2fDeviceAddFlowContainer.hide();
        u2fDeviceAddInitContainer.show();
        u2fAddDeviceNameInput.val("");
    }

    function initU2fRegister() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/u2f_resources/init_register?atl_token="+atlToken.val(),
            type: "POST",
            dataType: "JSON",
            contentType: "application/json; charset=utf-8",
            cache: false,
            success: function (data) {
                registerU2F(data);
            },
            error: function (data) {
                returnU2FStartPositionAddDevice();
                parseUserErrors(data);
            }
        });
    }

    function registerU2F(requestData) {
        u2f.register(
            requestData.appId,
            requestData.registerRequests,
            requestData.registeredKeys,
            function (data) {
                if (data.errorCode) {

                    if (data.errorCode === 4) {
                        alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.device_already_registred"));
                    } else {
                        alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.error_new_device") + data.errorCode);
                    }

                    returnU2FStartPositionAddDevice();
                    return;
                }

                u2fRegisterSubmitAction(data);
            }
        );
    }

    function u2fRegisterSubmitAction(data) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/u2f_resources/register?atl_token="+atlToken.val(),
            data: JSON.stringify({
                tokenResponse: JSON.stringify(data),
                deviceName: u2fAddDeviceNameInput.val()
            }),
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            type: "POST",
            cache: false,
            success: function (data) {
                alphaServe2FASuccessMessageFlag(AJS.I18n.getText("auth.text.log-u2f-add"));
                getRemoteUserU2FDevices(atlToken.val());
            },
            error: function (code) {
                parseUserErrors(code);
            }
        });

        returnU2FStartPositionAddDevice();
    }
});