function configuringDeviceLogin(env) {
    var u2fDeviceMessageContainer = AJS.$(".u2f-device-message-container");

    var rememberMeEnableCheckbox = AJS.$("#remember-me-user-enable");

    var rememberMeConfirmButton = AJS.$("#confirm-use-remember-me");

    var atlToken = AJS.$("input:hidden[name=atl_token]");

    rememberMeConfirmButton.hide();

    var loginWaysLinks = AJS.$(".tfa-enter-way-link");

    loginWaysLinks.bind("url-changed", function () {
        init();
    });
    init();

    function init() {
        if (getAlphaServe2FAEnterWay() === "u2f-login-way" && AJS.$("#no-valid-license").length === 0) {
            if (rememberMeConfirmButton.length > 0 && navigator.appVersion.indexOf("Win") !== -1) {
                rememberMeConfirmButton.show();
                rememberMeConfirmButton.unbind("click");
                rememberMeConfirmButton.bind("click", function () {
                    initU2fLogin();
                });
            } else {
                if (alphaServe2FACheckU2FBrowserCompatibility()) {
                    initU2fLogin();
                }
            }
        } else {
            if (u2f.port_) {
                u2f.port_.port_.disconnect();
                u2f.port_ = null;
            }
        }
    }

    function initU2fLogin() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/u2f_resources/init_login?atl_token="+atlToken.val(),
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            cache: false,
            success: function (data) {
                signU2F(data);
            },
            error: function (data) {
                if (data.status === 200 && data.readyState === 4) {//redirect
                    location.href = getAlphaServeLockedUrl();
                } else {
                    //IF UNKNOWN ERROR OCCURRED USER MUST USE TOTP
                    parseUserErrors(data);
                }
            }
        });
    }

    function signU2F(request) {
        if (request.signRequests.length > 0) {
            u2fDeviceMessageContainer.text(AJS.I18n.getText("auth.text.or_touch_token"));
            var startDate = new Date();
            u2f.sign(
                request.appId,
                request.challenge,
                request.signRequests,
                function (data) {
                    if (data.errorCode) {
                        switch (data.errorCode) {
                            case 4:
                                var seconds = (new Date().getTime() - startDate.getTime()) / 1000;
                                if (seconds <= 28) {
                                    alert(AJS.I18n.getText("auth.text.not_registered_device"));
                                }
                                break;
                        }
                        u2fDeviceMessageContainer.text(AJS.I18n.getText("auth.text.try_again_u2f"));
                        return;
                    }

                    u2fLoginSubmitAction(data);
                }
            );
        }
       // u2f.WrappedChromeRuntimePort_.prototype.disconnect()
    }

    function u2fLoginSubmitAction(data) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/u2f_resources/login?atl_token="+atlToken.val(),
            data: JSON.stringify({
                tokenResponse: JSON.stringify(data),
                rememberMe: rememberMeEnableCheckbox.attr('checked') !== undefined
            }),
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            type: "POST",
            cache: false,
            success: function (data) {
                redirectOrCloseDialog(env.inDialogWindow)
            },
            error: function (code) {
                parseUserErrors(code, AJS.I18n.getText("auth.text.auth-wrong-code"))
            }
        });
    }
}

AJS.$(document).ready(configuringDeviceLogin);
