AJS.$(document).ready(function () {

    window.onbeforeunload = null;

    var whitelistIPAddContainer = AJS.$(".add-whitelist-ip-container");
    var whitelistIPAddButtonContainer = AJS.$(".add-ip-filter-button-container");
    var whitelistIPAddCancelButtonContainer = AJS.$(".cancel-ip-filter-button-container");
    var whitelistIPDeleteConfigContainer = AJS.$("#delete-whitelist-ip-config-container");
    var rememberMeOptionsContainer = AJS.$(".remember-me-options-container");
    var authForceTypeGroupFieldContainer = AJS.$("#group-text-field-container");
    var authForceTypeAllExceptGroupFieldContainer = AJS.$("#except-group-text-field-container");
    var authForceTypeDirectoryFieldContainer = AJS.$("#directory-text-field-container");
    var authForceTypeAllExceptDirectoryFieldContainer = AJS.$("#except-directory-text-field-container");

    var authTrustedGroupsFieldContainer = AJS.$("#group-permission-field-container");
    var permissionLimitationFieldset = AJS.$("#permission-limitation-container");
    var authTrustedUsersFieldContainer = AJS.$("#user-permission-field-container");
    var authTrustedBulkEnabledBlock = AJS.$("#auth-trusted-bulk-enable-checkbox-block");
    var authPermissionLimitationGroupsFieldContainer = AJS.$("#group-permission-limitation-field-container");
    var authPermissionLimitationUsersFieldContainer = AJS.$("#user-permission-limitation-field-container");
    var whitelistIpConfigSchemaMoreDetailsLink = AJS.$("#whitelist-ip-config-schema-more-details");

    var whitelistIPAddButton = AJS.$(".whitelist-ip-add-button");
    var whitelistIPAddSubmitButton = AJS.$(".submit-add-whitelist-ip-button");
    var whitelistIPAddCancelButton = AJS.$(".cancel-ip-filter-button");
    var whitelistIPDeleteSubmitButton = AJS.$(".whitelist-delete-submit-button");
    var whitelistIPDialogCloseButton = AJS.$(".whitelist-delete-close-button");
    var configResetToDefaultsButton = AJS.$(".reset-to-defaults-button");
    var configResetToDefaultsSubmitButton = AJS.$(".reset-to-defaults-submit-button");
    var configResetToDefaultsCloseButton = AJS.$(".reset-to-defaults-close-button");
    var configAdminSaveButton = AJS.$(".save-admin-configuration-button");
    var deleteLogsButton = AJS.$(".delete-logs-button");
    var editTimestepButton = AJS.$("#edit-timestep-button");
    var editKeySizeButton = AJS.$("#edit-key-size-button");
    var confirmEditKeySizeButton = AJS.$("#edit-key-size-confirm");
    var confirmEditTimestepButton = AJS.$("#edit-timestep-confirm");
    var confirmCancelEditTimestepButton = AJS.$("#cancel-edit-timestep-confirm");
    var confirmCancelEditKeySizeButton = AJS.$("#cancel-edit-key-size-confirm");


    var enableRememberMeCheckbox = AJS.$("#auth-remember-me-enable-checkbox");

    var authForceTypeRadio = AJS.$(".auth-force-type-radio");
    var authPermissionTypeRadio = AJS.$(".auth-permission-type-radio");
    var authLimitationPermissionTypeRadio = AJS.$(".limitation-permission-type-radio");
    var authForceGroupRadio = AJS.$("#auth-force-type-groups");
    var authForceExceptGroupRadio = AJS.$("#auth-force-type-except-groups");
    var authForceDirectoryRadio = AJS.$("#forceDirectories");
    var authForceExceptDirectoryRadio = AJS.$("#forceAllExceptDirectories");
    var authTrustedGroupsRadio = AJS.$("#auth-permission-type-groups");
    var authTrustedNoneRadio = AJS.$("#auth-permission-type-none");
    var authTrustedUsersRadio = AJS.$("#auth-permission-type-users");
    var authExceptGroupRadio = AJS.$("#permission-limitation-type-groups");
    var authExceptUsersRadio = AJS.$("#permission-limitation-type-users");

    var resetToDefaultsDialog = AJS.dialog2("#delete-all-data-dialog");
    var whitelistIPDeleteDialog = AJS.dialog2("#delete-whitelist-ip-dialog");
    var editTimestepDialog = AJS.dialog2("#edit-timestep-dialog");
    var editKeySizeDialog = AJS.dialog2("#edit-key-size-dialog");

    var deleteLogsDateSelect = AJS.$("#delete-logs-date-select");

    var whitelistIPDeleteIdInput = AJS.$("#whitelist-ip-delete-id-input");
    var whitelistIPDeleteNameInput = AJS.$("#whitelist-ip-delete-name-input");
    var whitelistIPAddSettingInput = AJS.$("#whitelist-ip-setting-input");
    var whitelistIPAddNameInput = AJS.$("#whitelist-name-setting-input");
    var authForceTypeInput = AJS.$("#loaded-auth-force-type-input");
    var authPermissionTypeInputVal = AJS.$("#loaded-auth-permission-type-input").val();
    var authPermissionLimitationTypeInputValue = AJS.$("#loaded-auth-permission-limitation-type-input").val();

    var tfaAdminConfigForm = AJS.$("#tfa-admin-config-form");
    var enableBruteForceCheckbox = AJS.$("#auth-brute-force-enable");
    var numberOfAttempts = AJS.$("#number-of-attempts");
    var lockoutPer = AJS.$("#lockout-period");
    var atlToken = AJS.$("input:hidden[name=atl_token]");

    checkNTPSync2FA();
    deleteLogsDateSelect.auiSelect2();
    setDeleteButtons();
    createForceGroupSelect("#force-groups-select");
    createForceGroupSelect("#force-except-groups-select");
    createForceGroupSelect("#permission-groups-select");
    createForceGroupSelect("#permission-limitation-groups-select");
    createUserSelect("#permission-limitation-users-select");
    createUserSelect("#permission-users-select");
    deleteLogsDateSelect.val("ONE_DAY");
    forceOptions(authForceTypeInput.val());
    permissionOptions(authPermissionTypeInputVal, authPermissionLimitationTypeInputValue);
    rememberMeCheckSubOptions();
    createWhitelistInlineDialog();
    bruteForceSubOptions();

    configResetToDefaultsButton.unbind("click");
    configResetToDefaultsButton.bind("click", function () {
        resetToDefaultsDialog.show();
    });

    configResetToDefaultsCloseButton.unbind("click");
    configResetToDefaultsCloseButton.bind("click", function () {
        resetToDefaultsDialog.hide();
    });

    configResetToDefaultsSubmitButton.unbind("click");
    configResetToDefaultsSubmitButton.bind("click", function () {
        resetToDefaults2FA();
        resetToDefaultsDialog.hide();
    });

    whitelistIPAddButton.unbind("click");
    whitelistIPAddButton.bind("click", function () {
        whitelistIPAddContainer.show();
        whitelistIPAddButtonContainer.hide();
        whitelistIPAddCancelButtonContainer.show();
        AJS.$("#whitelist-ip-config-all").prop("checked", true);
    });

    configAdminSaveButton.unbind("click");
    configAdminSaveButton.bind("click", function () {
        saveAdminConfig2FA();
    });

    whitelistIPAddCancelButton.unbind("click");
    whitelistIPAddCancelButton.bind("click", function () {
        switchToAddWhiteFilter();
    });

    whitelistIPAddSubmitButton.unbind("click");
    whitelistIPAddSubmitButton.bind("click", function () {
        addWhitelistIp2FA();
    });

    whitelistIPDialogCloseButton.unbind("click");
    whitelistIPDialogCloseButton.bind("click", function () {
        whitelistIPDeleteDialog.hide();
    });

    whitelistIPDeleteSubmitButton.unbind("click");
    whitelistIPDeleteSubmitButton.bind("click", function (e) {
        var deleteId = whitelistIPDeleteIdInput.val();
        deleteIpFilter2FA(deleteId);
    });

    deleteLogsButton.unbind("click");
    deleteLogsButton.bind("click", function () {
        deleteLogs2FA();
    });

    enableRememberMeCheckbox.unbind("change");
    enableRememberMeCheckbox.bind("change", function () {
        rememberMeCheckSubOptions();
    });

    authForceTypeRadio.unbind("click");
    authForceTypeRadio.bind("click", function () {
        forceOptions(AJS.$(this).attr("value"));
    });

    authPermissionTypeRadio.unbind("click");
    authPermissionTypeRadio.bind("click", function () {
        authPermissionTypeInputVal = AJS.$(this).attr("value");
        permissionOptions(authPermissionTypeInputVal, authPermissionLimitationTypeInputValue);
    });

    authLimitationPermissionTypeRadio.unbind("click");
    authLimitationPermissionTypeRadio.bind("click", function () {
        authPermissionLimitationTypeInputValue = AJS.$(this).attr("value");
        permissionOptions(authPermissionTypeInputVal, authPermissionLimitationTypeInputValue);
    });

    enableBruteForceCheckbox.unbind("change");
    enableBruteForceCheckbox.bind("change", function () {
        bruteForceSubOptions();
    });

    editTimestepButton.unbind("click");
    editTimestepButton.bind("click", function () {
        editTimestepDialog.show();
    });

    confirmCancelEditTimestepButton.unbind("click");
    confirmCancelEditTimestepButton.bind("click", function () {
        editTimestepDialog.hide();
    });

    editKeySizeButton.unbind("click");
    editKeySizeButton.bind("click", function () {
        editKeySizeDialog.show();
    });

    confirmCancelEditKeySizeButton.unbind("click");
    confirmCancelEditKeySizeButton.bind("click", function () {
        editKeySizeDialog.hide();
    });

    confirmEditTimestepButton.unbind("click");
    confirmEditTimestepButton.bind("click", function () {
        AJS.$("#auth-totp-timestep").removeAttr("readonly");
        editTimestepDialog.hide();
        editTimestepButton.hide();
    });

    confirmEditKeySizeButton.unbind("click");
    confirmEditKeySizeButton.bind("click", function () {
        AJS.$("#auth-totp-keysize").removeAttr("readonly");
        editKeySizeDialog.hide();
        editKeySizeButton.hide();
    });

    function createWhitelistInlineDialog() {
        var ipConfigDialogText = "";

        AJS.$(AJS.I18n.getText("auth.text.whitelist-ip-config-schema-description").split(",")).each(function (d, e) {
            if (e === "\\n") {
                ipConfigDialogText = ipConfigDialogText.concat("<br/>");
            } else {
                ipConfigDialogText = ipConfigDialogText.concat("<div>" + e + "</div>");
            }
        });
        if (typeof AJS.InlineDialog !== 'undefined') {
            AJS.InlineDialog(whitelistIpConfigSchemaMoreDetailsLink, "whitelist-ip-schema-help",
                function (content, trigger, showPopup) {
                    content.css({ "padding": "20px" }).html(ipConfigDialogText);
                    showPopup();
                    return false;
                }
            );
        } else {
            var more = AJS.$("#whitelist-ip-config-schema-more-details");
            more.before("<a data-aui-trigger aria-controls='whitelist-ip-config-schema-more-details' href='#whitelist-ip-config-schema-more-details'>" +
                "<span class='aui-icon aui-icon-small aui-iconfont-help'>" +
                AJS.I18n.getText("auth.text.whitelist-ip-config-schema-icon") +
                "</span>" +
                "<aui-inline-dialog id='whitelist-ip-config-schema-more-details'>" +
                "<p>" +
                ipConfigDialogText +
                "</p>" +
                "</aui-inline-dialog>");
            more.remove();
        }
    }

    function switchToAddWhiteFilter() {
        whitelistIPAddContainer.hide();
        whitelistIPAddCancelButtonContainer.hide();
        whitelistIPAddButtonContainer.show();
        whitelistIPAddSettingInput.val("");
        whitelistIPAddNameInput.val("");
    }

    function setDeleteButtons() {
        var deleteIpFilterButtons = AJS.$(".delete-ip-filter-button");
        deleteIpFilterButtons.unbind("click");
        deleteIpFilterButtons.bind("click", function () {
            var deleteId = AJS.$(this).data("id");
            var deleteConfig = AJS.$(this).data("config");
            whitelistIPDeleteNameInput.val(deleteConfig);
            whitelistIPDeleteIdInput.val(deleteId);
            whitelistIPDeleteConfigContainer.html(deleteConfig);
            whitelistIPDeleteDialog.show();
        });
    }

    function rememberMeCheckSubOptions() {
        if (enableRememberMeCheckbox.is(":checked")) {
            rememberMeOptionsContainer.removeAttr("disabled");
        } else {
            rememberMeOptionsContainer.attr("disabled", "disabled");
        }
    }

    function bruteForceSubOptions() {
        if (enableBruteForceCheckbox.is(":checked")) {
            numberOfAttempts.removeAttr("disabled");
            lockoutPer.removeAttr("disabled");
        } else {
            numberOfAttempts.attr("disabled", "disabled");
            lockoutPer.attr("disabled", "disabled");
        }
    }

    function forceOptions(forceType) {
        var forceOption = AJS.$(".auth-force-type-radio[value='" + forceType + "']");
        forceOption.attr("checked", true);

        if (authForceGroupRadio.attr('checked')) {
            authForceTypeGroupFieldContainer.show();
        } else {
            authForceTypeGroupFieldContainer.hide();
        }

        if (authForceExceptGroupRadio.attr('checked')) {
            authForceTypeAllExceptGroupFieldContainer.show();
        } else {
            authForceTypeAllExceptGroupFieldContainer.hide();
        }

        if (authForceDirectoryRadio.attr('checked')) {
            authForceTypeDirectoryFieldContainer.show();
        } else {
            authForceTypeDirectoryFieldContainer.hide();
        }

        if (authForceExceptDirectoryRadio.attr('checked')) {
            authForceTypeAllExceptDirectoryFieldContainer.show();
        } else {
            authForceTypeAllExceptDirectoryFieldContainer.hide();
        }
    }

    function addWhitelistIp2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/ipfilterconfig/add?atl_token=" + atlToken.val(),
            data: JSON.stringify({
                ipConfig: whitelistIPAddSettingInput.val(),
                ipName: whitelistIPAddNameInput.val(),
                local: AJS.$("input[name='whitelist-ip-config-schema']:checked").val()
            }),
            dataType: "json",
            contentType: "application/json; charset=utf-8",
            type: "POST",
            cache: false,
            success: function (result) {
                whitelistIPAddContainer.hide();
                appendNewIpFilter2FA(result.id, result.ipConfig, result.ipName.replaceAll("'", "&apos;"), result.local);
                switchToAddWhiteFilter();
                setDeleteButtons();
            },
            error: function (e) {
                if (e.status === 400) {
                    alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.whitelist-ip-error"));
                } else {
                    alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
                }
            }
        });
    }

    function appendNewIpFilter2FA(ipId, ipConfig, ipName, ipLocal) {
        AJS.$("#whitefilter-table-container").append(
            "<div class='ip-filter-instance aui-group' data-id='" + ipId + "'>" +
            "     <input type='hidden' name='whitelistId' value='" + ipId + "'/>" +
            "     <div class='aui-item'>" +
            "          <span><input type='text' name='whitelistIpSetting' class='text filter-ip'" +
            "                       value='" + ipConfig + "'/></span>" +
            "     </div>" +
            "     <div class='aui-item'>" +
            "          <span><input type='text' name='whitelistNameSetting' class='text filter-name'" +
            "                       value='" + ipName + "'/></span>" +
            "     </div>" +
            "     <div class='aui-item'>" +
            "          <fieldset id='whitelistIpConfig-'" + ipId + ">" +
            "              <div>" +
            "                   <input id='whitelist-ip-config-all-" + ipId + "' type='radio'" +
            "                          name='whitelistIpConfig-" + ipId + "' class='checkbox filter-ip-config'" +
            "                          value='false' data-id='" + ipId + "' " + (ipLocal ? "" : "checked='checked'") + "/>" +
            "                   <label for='whitelist-ip-config-all-" + ipId + "'>" + AJS.I18n.getText('auth.text.all-headers') + "</label>" +
            "              </div>" +
            "              <div>" +
            "                   <input id='whitelist-ip-config-local-" + ipId + "' type='radio'" +
            "                          name='whitelistIpConfig-" + ipId + "' class='checkbox filter-ip-config'" +
            "                          value='true' data-id='" + ipId + "'" + (ipLocal ? "checked='checked'" : "") + "/>" +
            "                   <label for='whitelist-ip-config-local-" + ipId + "'>" + AJS.I18n.getText('auth.text.local-headers') + "</label>" +
            "              </div>" +
            "           </fieldset>" +
            "      </div>" +
            "      <div class='aui-item'>" +
            "           <span>" +
            "                   <input type='button' value='" + AJS.I18n.getText("auth.text.delete") + "'" +
            "                          class='delete-ip-filter-button aui-button aui-button-default'" +
            "                          data-id='" + ipId + "' data-config='" + ipConfig + "'>" +
            "           </span>" +
            "      </div>" +
            "      <div class='aui-item'></div>" +
            "      <div class='aui-item'></div>" +
            "</div>");
    }

    function resetToDefaults2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/tfaservices/reset?atl_token=" + atlToken.val(),
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            cache: false,
            success: function (data) {
                location.reload();
                alphaServe2FASuccessMessageFlag(AJS.I18n.getText("auth.text.saved"));
            },
            error: function (data) {
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
            }
        });
    }

    function deleteIpFilter2FA(deleteId) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/ipfilterconfig/delete?atl_token=" + atlToken.val(),
            data: JSON.stringify({
                id: whitelistIPDeleteIdInput.val()
            }),
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            cache: false,
            success: function () {
                var ipContainer = AJS.$(".ip-filter-instance[data-id='" + deleteId + "']");
                ipContainer.remove();

                whitelistIPDeleteDialog.hide();

                alphaServe2FASuccessMessageFlag(AJS.I18n.getText("auth.text.whitelist-ip-deleted"));
            },
            error: function () {
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
            }
        });
    }

    function deleteLogs2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/authlogger/delete?atl_token=" + atlToken.val(),
            dataType: "json",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify({
                loggerDate: deleteLogsDateSelect.val()
            }),
            type: "POST",
            cache: false,
            success: function (result) {
                alphaServe2FASuccessMessageFlag(AJS.I18n.getText("auth.text.logs-deleted"));
            },
            error: function (data) {
                if (data.status === 400) {
                    alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.delete-logs-error"));
                } else {
                    alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
                }
            }
        });
    }

    function checkNTPSync2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/time_service/get_ntp_time_sync",
            type: "GET",
            cache: false,
            success: function (result) {
                if (result) {
                    tfaAdminConfigForm.prepend("<div class='aui-message aui-message-warning'>" +
                        "<p class='title'>" + AJS.I18n.getText('auth.text.server-time-difference-text-header') + "</p>" +
                        AJS.I18n.getText('auth.text.server-time-difference-text') + "</div>");
                }
            },
            error: function (e) {
                //IF NTP WAS NOT RECEIVED THEN DO NOTHING
            }
        });
    }

    function saveAdminConfig2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/tfaservices/save_admin_config?atl_token=" + atlToken.val(),
            data: JSON.stringify(normalizeRadio(tfaAdminConfigForm.serializeObjectWithArray(["authForceGroupsList",
                "whitelistId",
                "whitelistIpSetting",
                "whitelistNameSetting",
                "authForceAllExceptGroupsList",
                "authPermissionGroupsList",
                "authPermissionUsersList",
                "limitationUsersList",
                "limitationGroupsList",
                "authForceAllExceptDirectoriesList",
                "directoriesList"]), "whitelistIpConfig")),
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            type: "POST",
            cache: false,
            success: function () {
                alphaServe2FASuccessMessageFlag(AJS.I18n.getText("auth.text.saved"));
            },
            error: function (errorCode) {
                parseErrors(errorCode);
            }
        });
    }

    function permissionOptions(type, limitationType) {
        var option = AJS.$(".auth-permission-type-radio[value='" + type + "']");
        option.attr("checked", true);

        if (limitationOption) {
            var limitationOption = AJS.$(".limitation-permission-type-radio[value='" + limitationType + "']");
            limitationOption.attr("checked", true);
        } else {
            AJS.$("#limitation-type-none").attr("checked", true);
        }

        if (authTrustedNoneRadio.attr('checked')) {
            authTrustedBulkEnabledBlock.hide();
        }

        if (authTrustedGroupsRadio.attr('checked')) {
            permissionLimitationFieldset.show();
            authTrustedGroupsFieldContainer.show();
            authTrustedBulkEnabledBlock.show();
        } else {
            permissionLimitationFieldset.hide();
            authTrustedGroupsFieldContainer.hide();
        }

        if (authTrustedUsersRadio.attr('checked')) {
            authTrustedUsersFieldContainer.show();
            authTrustedBulkEnabledBlock.show();
        } else {
            authTrustedUsersFieldContainer.hide();
        }

        if (authExceptGroupRadio.attr('checked')) {
            authPermissionLimitationGroupsFieldContainer.show();
        } else {
            authPermissionLimitationGroupsFieldContainer.hide();
        }

        if (authExceptUsersRadio.attr('checked')) {
            authPermissionLimitationUsersFieldContainer.show();
        } else {
            authPermissionLimitationUsersFieldContainer.hide();
        }
    }
});
function findGroups(value, targetSelect, isLengthLimit, atlToken) {
    if (!isLengthLimit || value.length > 0) {
        var target = AJS.$(targetSelect);
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/tfaservices/find_groups?atl_token=" + atlToken,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            data: JSON.stringify({
                name: value
            }),
            success: function (persons) {
                AJS.$.each(AJS.$(targetSelect + " option"), function (i, value) {
                    if (!value.selected) {
                        value.remove()
                    }
                });

                persons.forEach(function (entry) {
                    if (AJS.$.inArray(entry.name, target.val()) < 0) {
                        target.append("<option value='" + alphaServe2FAEscapeHtml(entry.name) + "'>" + alphaServe2FAEscapeHtml(entry.name) + "</option>");
                    }
                });
            }
        });
    }
}

function createUserSelect(selector) {
    AJS.$(selector).auiSelect2({ width: '500px' });
    var atlToken = AJS.$("input:hidden[name=atl_token]");

    findUsers("", selector, false, atlToken.val());

    var groupSelectInput = AJS.$("#s2id_" + selector.substring(1) + " .select2-input");

    groupSelectInput.unbind("input");
    groupSelectInput.bind("input", function () {
        findUsers(AJS.$(this).val(), selector, false, atlToken.val());
    });
}

function findUsers(value, targetSelect, isLengthLimit, atlToken) {
    if (!isLengthLimit || value.length > 0) {
        var target = AJS.$(targetSelect);
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/tfaservices/find_users_by_query" + (atlToken !== undefined ? "?atl_token=" + atlToken : ""),
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            data: JSON.stringify({
                username: value
            }),
            success: function (persons) {
                AJS.$.each(AJS.$(targetSelect + " option"), function (i, value) {
                    if (!value.selected) {
                        value.remove()
                    }
                });

                persons.forEach(function (entry) {
                    if (AJS.$.inArray(entry.username, target.val()) < 0) {
                        if (alphaServe2FAIsCurrentBrowserFirefox()) {
                            target.append("<option value='" + alphaServe2FAEscapeHtml(entry.username) + "' label='" + alphaServe2FAEscapeHtml(entry.username) + " (" + alphaServe2FAEscapeHtml(entry.email) + ")'>" + alphaServe2FAEscapeHtml(entry.username) + " (" + alphaServe2FAEscapeHtml(entry.email) + ")" + "</option>");
                        } else {
                            target.append("<option value='" + alphaServe2FAEscapeHtml(entry.username) + "'>" + alphaServe2FAEscapeHtml(entry.username) + " (" + alphaServe2FAEscapeHtml(entry.email) + ")" + "</option>");
                        }
                    }
                });
            }
        });
    }
}

