AJS.$(document).ready(function () {

    var user2FAResetButton = AJS.$("#reset-user-2fa-button");
    var bulkResetButton = AJS.$("#bulk-reset-button");

    var user2FADisableInput = AJS.$("#user-2fa-disable-input");
    var suggestUsersDatalist = AJS.$("#suggest-users-datalist");
    var atlToken = AJS.$("input:hidden[name=atl_token]");
    var authResetTypeGroupFieldContainer = AJS.$("#group-text-field-container");
    var authResetTypeAllExceptGroupFieldContainer = AJS.$("#except-group-text-field-container");
    var authResetTypeRadio = AJS.$(".bulk-reset-type-radio");

    var authResetGroupRadio = AJS.$("#bulk-reset-type-groups");
    var authResetExceptGroupRadio = AJS.$("#bulk-reset-type-except-groups");
    var resetGroupsSelect = AJS.$("#reset-groups-select");
    var resetExceptGroupsSelect = AJS.$("#reset-except-groups-select");
    var bulkResetDialog = AJS.dialog2("#bulk-reset-data-dialog");
    var bulkResetSubmitButton = AJS.$("#bulk-reset-submit-button");
    var bulkResetButtonCloseButton = AJS.$("#bulk-reset-close-button");

    user2FAResetButton.unbind("click");
    user2FAResetButton.bind("click", function () {
        resetUser2FA();
    });

    user2FADisableInput.unbind("input");
    user2FADisableInput.bind("input", function () {
        resetUser2FATypeUpdateAction();
    });

    bulkResetButton.unbind("click");
    bulkResetButton.bind("click", function () {
        bulkResetDialog.show();
    });

    authResetTypeRadio.unbind("click");
    authResetTypeRadio.bind("click", function () {
        var resetType = AJS.$(this).attr("value");
        if (resetType!=="resetNone") {
            bulkResetButton.prop('disabled', false);
            resetOptions(AJS.$(this).attr("value"));
        } else {
            bulkResetButton.prop('disabled', true);
        }
    });

    bulkResetButton.unbind("click");
    bulkResetButton.bind("click", function () {
        bulkResetDialog.show();
    });

    bulkResetButtonCloseButton.unbind("click");
    bulkResetButtonCloseButton.bind("click", function () {
        bulkResetDialog.hide();
    });

    bulkResetSubmitButton.unbind("click");
    bulkResetSubmitButton.bind("click", function () {
        bulkReset2FA();
        bulkResetDialog.hide();
    });

    bulkResetButton.prop('disabled', true);
    resetOptions("resetNone");
    createForceGroupSelect("#reset-groups-select");
    createForceGroupSelect("#reset-except-groups-select");

    function resetOptions(resetType) {
        var resetOption = AJS.$(".bulk-reset-type-radio[value='" + resetType + "']");
        resetOption.attr("checked", true);

        if (authResetGroupRadio.attr('checked')) {
            authResetTypeGroupFieldContainer.show();
        } else {
            authResetTypeGroupFieldContainer.hide();
        }

        if (authResetExceptGroupRadio.attr('checked')) {
            authResetTypeAllExceptGroupFieldContainer.show();
        } else {
            authResetTypeAllExceptGroupFieldContainer.hide();
        }
    }

    function resetUser2FATypeUpdateAction() {
        if (user2FADisableInput.val().length > 1) {
            AJS.$.ajax({
                url: AJS.contextPath() + "/rest/authpluginresources/1.0/tfaservices/find_users_by_query?atl_token=" + atlToken.val(),
                type: "POST",
                data: JSON.stringify({
                    username: user2FADisableInput.val()
                }),
                contentType: "application/json; charset=utf-8",
                dataType: 'json',
                success: function (persons) {
                    suggestUsersDatalist.html("");
                    persons.forEach(function (entry) {
                        if (alphaServe2FAIsCurrentBrowserFirefox()) {
                            suggestUsersDatalist.append("<option value='" + alphaServe2FAEscapeHtml(entry.username) + "' label='" + alphaServe2FAEscapeHtml(entry.username) + " (" + alphaServe2FAEscapeHtml(entry.email) + ")'>" + alphaServe2FAEscapeHtml(entry.email) + "</option>");
                        } else {
                            suggestUsersDatalist.append("<option value='" + alphaServe2FAEscapeHtml(entry.username) + "'>" + alphaServe2FAEscapeHtml(entry.email) + "</option>");
                        }
                    });
                }
            });
        }
    }

    function resetUser2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/totp_resources/reset_user_2fa?atl_token=" + atlToken.val(),
            data: JSON.stringify({
                username: user2FADisableInput.val()
            }),
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            cache: false,
            success: function (result) {
                alphaServe2FASuccessMessageFlag(AJS.I18n.getText("auth.text.user_auth_deleted"));
            },
            error: function (data) {
                parseErrors(data);
            }
        });
    }

    function bulkReset2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/totp_resources/bulk_reset_2fa?atl_token=" + atlToken.val(),
            data: JSON.stringify({
                type: AJS.$('input[name="bulkResetType"]:checked').val(),
                groups: resetGroupsSelect.val(),
                expectGroups: resetExceptGroupsSelect.val()
            }),
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            cache: false,
            success: function (result) {
                alphaServe2FASuccessMessageFlag(AJS.I18n.getText("auth.text.-bulk-reset-users_auth_deleted"));
            },
            error: function (data) {
                parseErrors(data);
            }
        });
    }
});

function findGroups(value, targetSelect, isLengthLimit, atlToken) {
    if (!isLengthLimit || value.length > 0) {
        var target = AJS.$(targetSelect);
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/tfaservices/find_groups?atl_token="+atlToken,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            data: JSON.stringify({
                name: value
            }),
            success: function (persons) {
                AJS.$.each(AJS.$(targetSelect + " option"), function(i, value){
                    if (!value.selected) {
                        value.remove()
                    }
                });

                persons.forEach(function (entry) {
                    if (AJS.$.inArray(entry.name, target.val()) < 0) {
                        target.append("<option value='" + alphaServe2FAEscapeHtml(entry.name) + "'>" + alphaServe2FAEscapeHtml(entry.name) + "</option>");
                    }
                });
            }
        });
    }
}
