AJS.$(window).load(function () {

    var dateSelectContainer = AJS.$("#selected-date-container");
    var authLoggerTableBody = AJS.$("#auth-logger-table tbody");
    var authLoggerPaginationPanel = AJS.$(".authentication-logger-pagination-panel");

    var filterUsernameInput = AJS.$("#log-username");
    var filterStartReportDateInput = AJS.$("#start-report-date");
    var filterFinishReportDateInput = AJS.$("#finish-report-date");
    var filterUserIPInput = AJS.$("#log-userip");
    var filterActionTypeSelect = AJS.$("#filter-action-select");

    var authLoggerFilterButton = AJS.$(".authentication-logs-filter-button");
    var selectDateDialogCloseButton = AJS.$("#select-date-dialog-close-button");
    var selectDateDialogButton = AJS.$("#date-select-button");
    var clearLoggerFilters = AJS.$(".clear-logger-filters-button");

    var datePickerInput = AJS.$(".auth-log-date-picker");
    var atlToken = AJS.$("input:hidden[name=atl_token]");

    filterActionTypeSelect.auiSelect2();
    initExport();
    loadPage(1);

    updateDateSelectContainerDate();

    clearLoggerFilters.unbind("click");
    clearLoggerFilters.bind("click", function () {
        filterUsernameInput.val("");
        filterUserIPInput.val("");
        filterStartReportDateInput.val(null);
        filterFinishReportDateInput.val(null);
        filterActionTypeSelect.val('All');
        filterActionTypeSelect.trigger('change');
        dateSelectContainer.html(" - ");
        loadPage(1);
    });

    selectDateDialogButton.unbind("click");
    selectDateDialogButton.bind("click", function () {
        AJS.dialog2("#select-date-dialog").show();
    });

    selectDateDialogCloseButton.unbind("click");
    selectDateDialogCloseButton.bind("click", function () {
        AJS.dialog2("#select-date-dialog").hide();
    });

    datePickerInput.unbind("change");
    datePickerInput.bind("change", function () {
        updateDateSelectContainerDate();
    });

    authLoggerFilterButton.unbind("click");
    authLoggerFilterButton.bind("click", function () {
        loadPage(1);
    });

    function updateDateSelectContainerDate() {
        dateSelectContainer.html(filterStartReportDateInput.val() + " - " + filterFinishReportDateInput.val());
    }

    function loadPage(page) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/authlogger/" + page + "?atl_token=" + atlToken.val(),
            dataType: "json",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify({
                username: filterUsernameInput.val(),
                startDate: filterStartReportDateInput.val(),
                finishDate: filterFinishReportDateInput.val(),
                action: filterActionTypeSelect.val(),
                userIp: filterUserIPInput.val(),
                page: page
            }),
            type: "POST",
            cache: false,
            success: function (data) {
                authLoggerPaginationPanel.html(pagination(page, data.pageCount, gotoPage));

                authLoggerTableBody.empty();

                appendAuthLoggerEntities(authLoggerTableBody, data.entities);
            },
            error: function () {
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
            }
        });
    }

    function gotoPage(event) {
        loadPage(event.data.pageNum);
    }

    function renderPrevious(currentPage, action) {
        if (currentPage > 1) {
            var link = AJS.$("<a href='#'>" + AJS.I18n.getText("auth.text.prev") + "</a>");
            link.on("click", {pageNum: currentPage - 1}, action);
            return AJS.$("<li></li>").addClass("aui-nav-previous").append(link);
        } else {
            return null;
        }
    }

    function renderNext(currentPage, lastPage, action) {
        if (currentPage < lastPage) {
            var link = AJS.$("<a href='#'>" + AJS.I18n.getText("auth.text.next") + "</a>");
            link.on("click", {pageNum: currentPage + 1}, action);
            return AJS.$("<li></li>").addClass("aui-nav-previous").append(link);
        } else {
            return null;
        }
    }

    function renderPageEntry(index, currentPage, action) {
        if (index === currentPage) {
            return "<li class='aui-nav-selected'>" + index + "</li>";
        } else {
            var link = AJS.$("<a href='#'>" + index + "</a>");
            link.on("click", {pageNum: index}, action);
            return AJS.$("<li></li>").append(link);
        }
    }

    function renderTruncation() {
        var link = AJS.$("<a href='#'>&hellip;</a>");
        return AJS.$("<li></li>").addClass("aui-nav-truncation").append(link);
    }

    function pagination(currentPage, lastPage, action) {
        var paginator = AJS.$("<ol></ol>").addClass("aui-nav").addClass("aui-nav-pagination");

        paginator.append(renderPrevious(currentPage, action));

        var left = Math.max(currentPage - 2, 1);
        var right = Math.min(currentPage + 2, lastPage);

        if (left > 1) {
            paginator.append(renderTruncation());
        }

        for (var i = left; i < right + 1; i++) {
            paginator.append(renderPageEntry(i, currentPage, action));
        }

        if (right < lastPage) {
            paginator.append(renderTruncation());
        }

        paginator.append(renderNext(currentPage, lastPage, action));

        return paginator;
    }

    function appendAuthLoggerEntities(tableBody, entities) {
        AJS.$(entities).each(function (d, e) {
            tableBody.append("<tr>" +
                "    <td>" + e.username + "</td>" +
                "    <td>" + e.date + "</td>" +
                "    <td>" + e.action + "</td>" +
                "    <td>" + e.userIp + "</td>" +
                "    <td></td>" +
                "</tr>")
        });
    }

    function initExport() {
        var exportButtons = AJS.$(".export-logs-link");

        exportButtons.unbind();
        exportButtons.on('click', function () {
            window.open(AJS.contextPath() + "/rest/authpluginresources/1.0/authlogger/export?" + getExportParams(AJS.$(this).attr("data-type")), "_blank");
        });
    }

    function getExportParams(type) {
        return "username=" + filterUsernameInput.val()
            + "&startDate=" +filterStartReportDateInput.val()
            + "&finishDate=" + filterFinishReportDateInput.val()
            + "&action=" + filterActionTypeSelect.val()
            + "&userIp=" + filterUserIPInput.val()
            + "&type=" + type;
    }
});


