/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class AssertionRequest {
    @NonNull
    private final PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions;
    private final String username;
    private final ByteArray userHandle;

    @JsonCreator
    private AssertionRequest(@JsonProperty(value="publicKeyCredentialRequestOptions") @NonNull PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, @JsonProperty(value="username") String username, @JsonProperty(value="userHandle") ByteArray userHandle) {
        if (publicKeyCredentialRequestOptions == null) {
            throw new NullPointerException("publicKeyCredentialRequestOptions is marked non-null but is null");
        }
        this.publicKeyCredentialRequestOptions = publicKeyCredentialRequestOptions;
        if (userHandle != null) {
            this.username = null;
            this.userHandle = userHandle;
        } else {
            this.username = username;
            this.userHandle = null;
        }
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public Optional<ByteArray> getUserHandle() {
        return Optional.ofNullable(this.userHandle);
    }

    public String toCredentialsGetJson() throws JsonProcessingException {
        return this.publicKeyCredentialRequestOptions.toCredentialsGetJson();
    }

    public String toJson() throws JsonProcessingException {
        return JacksonCodecs.json().writeValueAsString(this);
    }

    public static AssertionRequest fromJson(String json) throws JsonProcessingException {
        return JacksonCodecs.json().readValue(json, AssertionRequest.class);
    }

    public static AssertionRequestBuilder.MandatoryStages builder() {
        return new AssertionRequestBuilder.MandatoryStages();
    }

    @Generated
    public AssertionRequestBuilder toBuilder() {
        return new AssertionRequestBuilder().publicKeyCredentialRequestOptions(this.publicKeyCredentialRequestOptions).username(this.username).userHandle(this.userHandle);
    }

    @NonNull
    @Generated
    public PublicKeyCredentialRequestOptions getPublicKeyCredentialRequestOptions() {
        return this.publicKeyCredentialRequestOptions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssertionRequest)) {
            return false;
        }
        AssertionRequest other = (AssertionRequest)o;
        PublicKeyCredentialRequestOptions this$publicKeyCredentialRequestOptions = this.getPublicKeyCredentialRequestOptions();
        PublicKeyCredentialRequestOptions other$publicKeyCredentialRequestOptions = other.getPublicKeyCredentialRequestOptions();
        if (this$publicKeyCredentialRequestOptions == null ? other$publicKeyCredentialRequestOptions != null : !((Object)this$publicKeyCredentialRequestOptions).equals(other$publicKeyCredentialRequestOptions)) {
            return false;
        }
        Optional<String> this$username = this.getUsername();
        Optional<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        Optional<ByteArray> this$userHandle = this.getUserHandle();
        Optional<ByteArray> other$userHandle = other.getUserHandle();
        return !(this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublicKeyCredentialRequestOptions $publicKeyCredentialRequestOptions = this.getPublicKeyCredentialRequestOptions();
        result = result * 59 + ($publicKeyCredentialRequestOptions == null ? 43 : ((Object)$publicKeyCredentialRequestOptions).hashCode());
        Optional<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        Optional<ByteArray> $userHandle = this.getUserHandle();
        result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssertionRequest(publicKeyCredentialRequestOptions=" + this.getPublicKeyCredentialRequestOptions() + ", username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ")";
    }

    public static class AssertionRequestBuilder {
        @Generated
        private PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions;
        private String username = null;
        private ByteArray userHandle = null;

        public AssertionRequestBuilder username(@NonNull Optional<String> username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            return this.username((String)username.orElse(null));
        }

        public AssertionRequestBuilder username(String username) {
            this.username = username;
            if (username != null) {
                this.userHandle = null;
            }
            return this;
        }

        public AssertionRequestBuilder userHandle(@NonNull Optional<ByteArray> userHandle) {
            if (userHandle == null) {
                throw new NullPointerException("userHandle is marked non-null but is null");
            }
            return this.userHandle((ByteArray)userHandle.orElse(null));
        }

        public AssertionRequestBuilder userHandle(ByteArray userHandle) {
            if (userHandle != null) {
                this.username = null;
            }
            this.userHandle = userHandle;
            return this;
        }

        @Generated
        AssertionRequestBuilder() {
        }

        @Generated
        public AssertionRequestBuilder publicKeyCredentialRequestOptions(@NonNull PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) {
            if (publicKeyCredentialRequestOptions == null) {
                throw new NullPointerException("publicKeyCredentialRequestOptions is marked non-null but is null");
            }
            this.publicKeyCredentialRequestOptions = publicKeyCredentialRequestOptions;
            return this;
        }

        @Generated
        public AssertionRequest build() {
            return new AssertionRequest(this.publicKeyCredentialRequestOptions, this.username, this.userHandle);
        }

        @Generated
        public String toString() {
            return "AssertionRequest.AssertionRequestBuilder(publicKeyCredentialRequestOptions=" + this.publicKeyCredentialRequestOptions + ", username=" + this.username + ", userHandle=" + this.userHandle + ")";
        }

        public static class MandatoryStages {
            private final AssertionRequestBuilder builder = new AssertionRequestBuilder();

            public AssertionRequestBuilder publicKeyCredentialRequestOptions(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) {
                return this.builder.publicKeyCredentialRequestOptions(publicKeyCredentialRequestOptions);
            }
        }
    }
}

