/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation.core;

import com.alphaserve.twofactor.core.validation.core.ValidationError;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.List;

public class ValidationResult {
    private I18nResolver i18nResolver;
    private List<ValidationError> errors = new ArrayList<ValidationError>();

    private ValidationResult(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public static ValidationResult init(I18nResolver i18nResolver) {
        return new ValidationResult(i18nResolver);
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public void addError(String code) {
        this.errors.add(ValidationError.initError(code, this.i18nResolver.getText(code)));
    }

    public void addErrors(List<ValidationError> errors) {
        this.errors.addAll(errors);
    }

    public void addError(String code, String message) {
        this.errors.add(ValidationError.initError(code, this.i18nResolver.getText(code), message));
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }
}

