/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.dtolayer.dtos.UsernameDTO;
import com.alphaserve.twofactor.core.model.entities.cache.wraper.Auth2FACacheWrapper;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Named
@Component
public class UsernameValidation
implements Validator<UsernameDTO> {
    @ComponentImport
    private I18nResolver i18nResolver;
    @ComponentImport
    private final UserManager userManager;
    private Auth2FAService auth2FAService;

    @Inject
    public UsernameValidation(I18nResolver i18nResolver, @Qualifier(value="userManager") UserManager userManager, Auth2FAService auth2FAService) {
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.auth2FAService = auth2FAService;
    }

    @Override
    public ValidationResult validate(UsernameDTO usernameDTO) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        if (StringUtils.isBlank(usernameDTO.getUsername())) {
            validationResult.addError("auth.text.user-auth-empty-field");
            return validationResult;
        }
        UserProfile userByKey = this.userManager.getUserProfile(usernameDTO.getUsername());
        if (Objects.isNull(userByKey)) {
            validationResult.addError("auth.text.user-auth-deleted-error");
            return validationResult;
        }
        Auth2FACacheWrapper byUserKey = this.auth2FAService.getWrappedEntityByUserKey(userByKey.getUserKey());
        if (Objects.isNull(byUserKey)) {
            validationResult.addError("auth.text.user-auth-not-exist");
        }
        return validationResult;
    }
}

