/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.validation.core.SimpleValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class User2faEnabledValidation
implements SimpleValidator {
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final AuthLoginService authLoginService;
    private final UserService userService;

    @Inject
    public User2faEnabledValidation(I18nResolver i18nResolver, AuthLoginService authLoginService, UserService userService) {
        this.i18nResolver = i18nResolver;
        this.authLoginService = authLoginService;
        this.userService = userService;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        if (!this.authLoginService.isUserHave2fa()) {
            validationResult.addError("auth.text.error-2fa-not-enabled");
        }
        return validationResult;
    }

    public ValidationResult validate(String username) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        if (!this.authLoginService.isUserHave2fa(username)) {
            validationResult.addError("auth.text.error-2fa-not-enabled");
        }
        return validationResult;
    }
}

