/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.PluginInfoService;
import com.alphaserve.twofactor.core.validation.core.SimpleValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.stereotype.Component;

@Named
@Component
public class DisableTotpValidation
implements SimpleValidator {
    @ComponentImport
    private I18nResolver i18nResolver;
    private final PluginInfoService pluginInfoService;
    private final ConfigurationService configurationService;

    @Inject
    public DisableTotpValidation(I18nResolver i18nResolver, PluginInfoService pluginInfoService, ConfigurationService configurationService) {
        this.i18nResolver = i18nResolver;
        this.pluginInfoService = pluginInfoService;
        this.configurationService = configurationService;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        if (this.configurationService.getHideDeactivate2fa() && !this.pluginInfoService.isAdministrator()) {
            validationResult.addError("auth.text.not.permissions");
            return validationResult;
        }
        return validationResult;
    }
}

